/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module tmod_core(CLK, RST,
                 DIN,
                 DOUT);

   input  CLK, RST;
   input  [127:0] DIN;
   output [31:0]  DOUT;

   wire [31:0]    anew, aold, told, tau;

   assign         anew = DIN[31:0];
   assign         aold = DIN[63:32];
   assign         told = DIN[95:64];
   assign         tau  = DIN[127:96];

   wire [31:0]    fadd_a, fadd_b, fadd_q;
   wire [31:0]    fsub_a, fsub_b, fsub_q;
   wire [31:0]    fmul_a, fmul_b, fmul_q;
   wire [31:0]    fdiv_a, fdiv_b, fdiv_q;
   
   reg [32*16-1 : 0] sr_fsq;
   reg [32*36-1 : 0] sr_tau;

   always@(posedge CLK) begin
      sr_fsq <= {sr_fsq[32*15-1:0], fsub_q};
      sr_tau <= {sr_tau[32*35-1:0], tau};
   end

   assign fdiv_a = aold;
   assign fdiv_b = anew;

   assign fsub_a = told;
   assign fsub_b = tau;
   
   assign fmul_a = fdiv_q;
   assign fmul_b = sr_fsq[32*16-1:32*15];
   
   assign fadd_a = fmul_q;
   assign fadd_b = sr_tau[32*36-1:32*35];

   assign DOUT = fadd_q;
   
   fadd_hs_fu fadd(.clk(CLK),
                   .a(fadd_a),
                   .b(fadd_b),
                   .result(fadd_q));

   fsub_hs_fu fsub(.clk(CLK),
                   .a(fsub_a),
                   .b(fsub_b),
                   .result(fsub_q));

   fmul_mu fmul(.clk(CLK),
                .a(fmul_a),
                .b(fmul_b),
                .result(fmul_q));

   fdiv fdiv(.clk(CLK),
             .a(fdiv_a),
             .b(fdiv_b),
             .result(fdiv_q));

endmodule // tmod
