/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module pcal_core(CLK, RST,
                 RCWE, RCADR, RCDIN,
                 REQ,
                 DIN, DOUT);

   input        CLK, RST;
   input        RCWE;
   input [9:0]  RCADR;
   input [31:0] RCDIN;
   input        REQ;
   input  [75:0] DIN;
   output [31:0] DOUT;

   wire           wea;
   wire [9:0]     addra, addrb;
   wire [31:0]    dina, doutb;

   reg            set_flag;
   reg [9:0]      addr;
   reg [9:0]      num;
   
   wire [31:0] fm_a, fm_b, fm_q;
   wire [31:0] im_a, im_b;
   wire [63:0] im_q;
   wire [31:0] if_a, if_q;

   reg [31:0]  ia, ib;

   reg [10*21 - 1 : 0]  sr_rid;
   
   always@(posedge CLK) begin
      if(REQ) begin
         casex(DIN[75:74])
           2'b01 : begin
              ia <= DIN[31:0];
              ib <= DIN[63:32];
           end
           2'b10 : begin
              ia <= DIN[31:0];
              ib <= 32'd1;
           end
           2'b11 : begin
              if(DIN[0]) begin
                 ia <= {1'b0, DIN[31:1]};
                 ib <= DIN[31:0];
              end
              else begin
                 ia <= {1'b0, DIN[31:1]};
                 ib <= DIN[31:0] - 1;
              end
           end
           default : begin
              ia <= DIN[31:0];
              ib <= DIN[63:32];
           end
         endcase // casex(DIN[75:74])
      end // if (REQ)
      sr_rid <= {sr_rid[10*20 - 1 : 0], DIN[73:64]};
   end

   assign im_a = ia;
   assign im_b = ib;
   assign if_a = im_q;

   assign wea   = RCWE;
   assign addra = (RCWE) ? RCADR : addr;
   assign dina  = RCDIN;

   assign addrb = sr_rid[10*12-1:10*11];

   assign fm_a = doutb;
   assign fm_b = if_q;
   
   sdpram32x10 rcmem(.clka(CLK), .clkb(CLK),
                     .wea(wea),
                     .addra(addra),
                     .dina(dina),
                     .addrb(addrb),
                     .doutb(doutb));

   imul32 im(.clk(CLK),
             .a(im_a),
             .b(im_b),
             .p(im_q));

   itof32 i2f(.clk(CLK),
              .a(if_a),
              .result(if_q));
   
   fmul_mu fm(.clk(CLK),
              .a(fm_a),
              .b(fm_b),
              .result(fm_q));

   assign DOUT = fm_q;
   
endmodule // pcal
