/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

module lt(CLK,
          a,
          b,
          q);

   input CLK;
   input [31:0] a;
   input [31:0] b;
   output q;

   wire        sa,sb;
   wire [7:0]  ea,eb;
   wire [22:0] fa,fb;

   assign sa = a[31];
   assign sb = b[31];
   assign ea = a[30:23];
   assign eb = b[30:23];
   assign fa = a[22:0];
   assign fb = b[22:0];

   reg        sqa,sqb;
   reg [8:0]  eq;
   reg [23:0] fq;
   always@(posedge CLK) begin
      sqa <= sa;
      sqb <= sb;
      eq  <= {1'b0,ea} - {1'b0,eb};
      fq  <= {1'b0,fa} - {1'b0,fb};
   end
   
   wire        ee;
   wire        ff;
   reg         q;
   
   assign ee = ~|eq[7:0];
   assign ff = ~|fq[22:0];

   always@(posedge CLK) begin
      if((sqa & ~sqb) | ((~sqa & ~sqb) & (eq[8] | (ee & fq[23]) | (ee & ff))))
         q <= 1'b1;
      else
         q <= 1'b0;
   end

endmodule // lt
