/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module demux20(CLK, 
              IREQ, IRDY, DIN, DOUT,
              OREQ0, ORDY0,
              OREQ1, ORDY1,
              OREQ2, ORDY2,
              OREQ3, ORDY3,
              OREQ4, ORDY4,
              OREQ5, ORDY5,
              OREQ6, ORDY6,
              OREQ7, ORDY7,
              OREQ8, ORDY8,
              OREQ9, ORDY9,
              OREQ10, ORDY10,
              OREQ11, ORDY11,
              OREQ12, ORDY12,
              OREQ13, ORDY13,
              OREQ14, ORDY14,
              OREQ15, ORDY15,
              OREQ16, ORDY16,
              OREQ17, ORDY17,
              OREQ18, ORDY18,
              OREQ19, ORDY19,
              RST);
   input CLK;
   input RST;

   input [1:0]    IREQ;
   output         IRDY;
   input  [31:0]  DIN;
   output [31:0]  DOUT;

   output [1:0]   OREQ0, OREQ1, OREQ2, OREQ3, OREQ4, OREQ5, OREQ6, OREQ7, OREQ8, OREQ9, OREQ10, OREQ11, OREQ12, OREQ13, OREQ14, OREQ15, OREQ16, OREQ17, OREQ18, OREQ19;
   input          ORDY0, ORDY1, ORDY2, ORDY3, ORDY4, ORDY5, ORDY6, ORDY7, ORDY8, ORDY9, ORDY10, ORDY11, ORDY12, ORDY13, ORDY14, ORDY15, ORDY16, ORDY17, ORDY18, ORDY19;

   reg       STATE;
   wire      ORDY;
   reg [19:0] ENC;
   reg [19:0] PND;

   wire FIFO_WE, FIFO_RE;
   wire FIFO_FULL;
   wire [`FIFO_WIDTH - 1 : 0] FIFO_DIN, FIFO_DOUT;

   assign OREQ0 = (STATE & ENC[0]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ1 = (STATE & ENC[1]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ2 = (STATE & ENC[2]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ3 = (STATE & ENC[3]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ4 = (STATE & ENC[4]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ5 = (STATE & ENC[5]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ6 = (STATE & ENC[6]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ7 = (STATE & ENC[7]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ8 = (STATE & ENC[8]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ9 = (STATE & ENC[9]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ10 = (STATE & ENC[10]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ11 = (STATE & ENC[11]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ12 = (STATE & ENC[12]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ13 = (STATE & ENC[13]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ14 = (STATE & ENC[14]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ15 = (STATE & ENC[15]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ16 = (STATE & ENC[16]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ17 = (STATE & ENC[17]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ18 = (STATE & ENC[18]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ19 = (STATE & ENC[19]) ? FIFO_DOUT[33:32] : 2'b00;

   assign ORDY = (ENC[0]) ? ORDY0 :
                 (ENC[1]) ? ORDY1 :
                 (ENC[2]) ? ORDY2 :
                 (ENC[3]) ? ORDY3 :
                 (ENC[4]) ? ORDY4 :
                 (ENC[5]) ? ORDY5 :
                 (ENC[6]) ? ORDY6 :
                 (ENC[7]) ? ORDY7 :
                 (ENC[8]) ? ORDY8 :
                 (ENC[9]) ? ORDY9 :
                 (ENC[10]) ? ORDY10 :
                 (ENC[11]) ? ORDY11 :
                 (ENC[12]) ? ORDY12 :
                 (ENC[13]) ? ORDY13 :
                 (ENC[14]) ? ORDY14 :
                 (ENC[15]) ? ORDY15 :
                 (ENC[16]) ? ORDY16 :
                 (ENC[17]) ? ORDY17 :
                 (ENC[18]) ? ORDY18 :
                 (ENC[19]) ? ORDY19 : `DISABLE;

   assign IRDY = ~FIFO_FULL;
   assign FIFO_WE  = |IREQ & ~FIFO_FULL;
   assign FIFO_DIN = {IREQ, DIN};
   assign FIFO_RE  = STATE & ORDY;

   bus_fifo fifo(.CLK(CLK), .RST(RST),
                 .WE(FIFO_WE),
                 .RE(FIFO_RE),
                 .FULL(FIFO_FULL),
                 .DIN(FIFO_DIN),
                 .DOUT(FIFO_DOUT));

   function [19:0] encode;
      input [4:0] addr;
      begin
         casex(addr)
           5'b00000 : encode = 20'b00000000000000000001;
           5'b00001 : encode = 20'b00000000000000000010;
           5'b00010 : encode = 20'b00000000000000000100;
           5'b00011 : encode = 20'b00000000000000001000;
           5'b00100 : encode = 20'b00000000000000010000;
           5'b00101 : encode = 20'b00000000000000100000;
           5'b00110 : encode = 20'b00000000000001000000;
           5'b00111 : encode = 20'b00000000000010000000;
           5'b01000 : encode = 20'b00000000000100000000;
           5'b01001 : encode = 20'b00000000001000000000;
           5'b01010 : encode = 20'b00000000010000000000;
           5'b01011 : encode = 20'b00000000100000000000;
           5'b01100 : encode = 20'b00000001000000000000;
           5'b01101 : encode = 20'b00000010000000000000;
           5'b01110 : encode = 20'b00000100000000000000;
           5'b01111 : encode = 20'b00001000000000000000;
           5'b10000 : encode = 20'b00010000000000000000;
           5'b10001 : encode = 20'b00100000000000000000;
           5'b10010 : encode = 20'b01000000000000000000;
           5'b10011 : encode = 20'b10000000000000000000;
           default : encode = 20'b0;
         endcase // casex(addr)
      end
   endfunction // encode

   assign DOUT = (FIFO_DOUT[33:32] == 2'b01) ? {FIFO_DOUT[31:20], FIFO_DOUT[14:0], FIFO_DOUT[19:15]} : FIFO_DOUT[31:0];

   always@(posedge CLK) begin
      if(RST) begin
         STATE <= 1'b0;
         ENC   <= 20'b0;
         PND   <= 20'b0;
      end
      else begin
         if(STATE & IREQ == 2'b01) PND <= encode(DIN[19:15]);
         if(~STATE) begin
            if(|IREQ) begin
               STATE <= 1'b1;
               ENC   <= encode(DIN[19:15]);
            end
         end
         else begin
            if(FIFO_DOUT[33:32] == 2'b10 & ORDY) begin
               if(IREQ == 2'b01) ENC   <= encode(DIN[19:15]);
               else if(IREQ[1])  ENC   <= PND;
               else              STATE <= 1'b0;
            end
         end
      end
   end
endmodule // demux20
