/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module no4(CLK, RST,
           SEL,
           PURGE,
           DIN0, DIN1, DIN2, DIN3,
           OREQ,ORDY,
           DOUT);

   input CLK;
   input RST;

   output PURGE;

   input [3:0] SEL;
   output [1:0] OREQ;
   input        ORDY;
   input  [`FIFO_WIDTH - 1 : 0]  DIN0,  DIN1,  DIN2,  DIN3;
   output [`DATA_WIDTH - 1 : 0] DOUT;

   assign    PURGE = (OREQ == 2'b10) & ORDY;

   assign    OREQ = (SEL[0]) ? DIN0[33:32] :
                      (SEL[1]) ? DIN1[33:32] :
                      (SEL[2]) ? DIN2[33:32] :
                      (SEL[3]) ? DIN3[33:32] :
                                 2'b0;

   assign    DOUT = (SEL[0]) ? DIN0[`DATA_WIDTH - 1:0] :
                    (SEL[1]) ? DIN1[`DATA_WIDTH - 1:0] :
                    (SEL[2]) ? DIN2[`DATA_WIDTH - 1:0] :
                    (SEL[3]) ? DIN3[`DATA_WIDTH - 1:0] :
                               32'b0;

endmodule // no4
