/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module ni(CLK, RST,
          IREQ,
          IRDY,
          DIN,
          RE,
          REQ,
          DOUT);

   input  CLK, RST;
   input  [1:0] IREQ;
   output IRDY;
   input  [`DATA_WIDTH - 1 : 0] DIN;
   input                        RE;
   output                       REQ;
   output [`FIFO_WIDTH - 1 : 0] DOUT;

   wire FIFO_WE, FIFO_RE;
   wire FIFO_FULL;
   wire [`FIFO_WIDTH - 1 : 0] FIFO_DIN, FIFO_DOUT;

   assign IRDY     = ~FIFO_FULL;
   assign DOUT     = FIFO_DOUT;
   assign FIFO_WE  = |IREQ & ~FIFO_FULL;
   assign FIFO_DIN = {IREQ, DIN};

   assign FIFO_RE  = RE;

   assign REQ = (FIFO_DOUT[33:32] == 2'b01) | (IREQ == 2'b01);
   
   bus_fifo fifo(.CLK(CLK), .RST(RST),
                 .WE(FIFO_WE),
                 .RE(FIFO_RE),
                 .FULL(FIFO_FULL),
                 .DIN(FIFO_DIN),
                 .DOUT(FIFO_DOUT));
   
endmodule
