/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module bus6(CLK, RST,
            IREQ0, IRDY0, DIN0,
            IREQ1, IRDY1, DIN1,
            IREQ2, IRDY2, DIN2,
            IREQ3, IRDY3, DIN3,
            IREQ4, IRDY4, DIN4,
            IREQ5, IRDY5, DIN5,
            OREQ, ORDY, DOUT
            );

   input  CLK,RST;

   input [1:0] IREQ0;
   output      IRDY0;
   input [`DATA_WIDTH - 1 : 0] DIN0;

   input [1:0] IREQ1;
   output      IRDY1;
   input [`DATA_WIDTH - 1 : 0] DIN1;

   input [1:0] IREQ2;
   output      IRDY2;
   input [`DATA_WIDTH - 1 : 0] DIN2;

   input [1:0] IREQ3;
   output      IRDY3;
   input [`DATA_WIDTH - 1 : 0] DIN3;

   input [1:0] IREQ4;
   output      IRDY4;
   input [`DATA_WIDTH - 1 : 0] DIN4;

   input [1:0] IREQ5;
   output      IRDY5;
   input [`DATA_WIDTH - 1 : 0] DIN5;



   output [1:0] OREQ;
   input        ORDY;
   output [`DATA_WIDTH - 1 : 0] DOUT;

   wire [`FIFO_WIDTH - 1 : 0]   DOUT0, DOUT1, DOUT2, DOUT3, DOUT4, DOUT5;


   wire       PURGE;
   wire [5:0] SEL, AREQ;

   ni ni0(.CLK(CLK), .RST(RST),
          .IREQ(IREQ0), .IRDY(IRDY0), .DIN(DIN0),
          .RE(SEL[0] & ORDY),
          .REQ(AREQ[0]),
          .DOUT(DOUT0));

   ni ni1(.CLK(CLK), .RST(RST),
          .IREQ(IREQ1), .IRDY(IRDY1), .DIN(DIN1),
          .RE(SEL[1] & ORDY),
          .REQ(AREQ[1]),
          .DOUT(DOUT1));

   ni ni2(.CLK(CLK), .RST(RST),
          .IREQ(IREQ2), .IRDY(IRDY2), .DIN(DIN2),
          .RE(SEL[2] & ORDY),
          .REQ(AREQ[2]),
          .DOUT(DOUT2));

   ni ni3(.CLK(CLK), .RST(RST),
          .IREQ(IREQ3), .IRDY(IRDY3), .DIN(DIN3),
          .RE(SEL[3] & ORDY),
          .REQ(AREQ[3]),
          .DOUT(DOUT3));

   ni ni4(.CLK(CLK), .RST(RST),
          .IREQ(IREQ4), .IRDY(IRDY4), .DIN(DIN4),
          .RE(SEL[4] & ORDY),
          .REQ(AREQ[4]),
          .DOUT(DOUT4));

   ni ni5(.CLK(CLK), .RST(RST),
          .IREQ(IREQ5), .IRDY(IRDY5), .DIN(DIN5),
          .RE(SEL[5] & ORDY),
          .REQ(AREQ[5]),
          .DOUT(DOUT5));


   arbiter6 arbiter(.CLK(CLK), .RST(RST),
                    .REQ(AREQ),
                    .SEL(SEL),
                    .PURGE(PURGE));

   no6 no(.CLK(CLK), .RST(RST),
          .SEL(SEL),
          .PURGE(PURGE),
          .DIN0(DOUT0), .DIN1(DOUT1), .DIN2(DOUT2), .DIN3(DOUT3), .DIN4(DOUT4), .DIN5(DOUT5),
          .OREQ(OREQ),  .ORDY(ORDY),  .DOUT(DOUT));

endmodule // bus6
