/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module bus2(CLK, RST,
            IREQ0, IRDY0, DIN0,
            IREQ1, IRDY1, DIN1,
            OREQ, ORDY, DOUT
            );

   input  CLK,RST;

   input [1:0] IREQ0;
   output      IRDY0;
   input [`DATA_WIDTH - 1 : 0] DIN0;

   input [1:0] IREQ1;
   output      IRDY1;
   input [`DATA_WIDTH - 1 : 0] DIN1;



   output [1:0] OREQ;
   input        ORDY;
   output [`DATA_WIDTH - 1 : 0] DOUT;

   wire [`FIFO_WIDTH - 1 : 0]   DOUT0, DOUT1;


   wire       PURGE;
   wire [1:0] SEL, AREQ;

   ni ni0(.CLK(CLK), .RST(RST),
          .IREQ(IREQ0), .IRDY(IRDY0), .DIN(DIN0),
          .RE(SEL[0] & ORDY),
          .REQ(AREQ[0]),
          .DOUT(DOUT0));

   ni ni1(.CLK(CLK), .RST(RST),
          .IREQ(IREQ1), .IRDY(IRDY1), .DIN(DIN1),
          .RE(SEL[1] & ORDY),
          .REQ(AREQ[1]),
          .DOUT(DOUT1));

   arbiter2 arbiter(.CLK(CLK), .RST(RST),
                    .REQ(AREQ),
                    .SEL(SEL),
                    .PURGE(PURGE));

   no2 no(.CLK(CLK), .RST(RST),
          .SEL(SEL),
          .PURGE(PURGE),
          .DIN0(DOUT0), .DIN1(DOUT1),
          .OREQ(OREQ),  .ORDY(ORDY),  .DOUT(DOUT));

endmodule // bus2
