/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"
module arbiter6(CLK, RST,
                REQ,
                SEL,
                PURGE);

   input CLK, RST;
   input  [5 : 0]  REQ;
   output [5 : 0]  SEL;
   input         PURGE;
   
   reg [5 : 0]     PRIORITY;
   reg [5 : 0]     SEL;
   reg           STATE;

   function [5:0] SEL_REQ;
      input [5:0] PRI;
      input [5:0] IREQ;
      begin
         casex(PRI)
           6'b000001 : begin
             casex(IREQ)
               6'bxxxxx1 : SEL_REQ = 6'b000001;
               6'bxxxx10 : SEL_REQ = 6'b000010;
               6'bxxx100 : SEL_REQ = 6'b000100;
               6'bxx1000 : SEL_REQ = 6'b001000;
               6'bx10000 : SEL_REQ = 6'b010000;
               6'b100000 : SEL_REQ = 6'b100000;
               default : SEL_REQ = 6'b0;
             endcase
           end
           6'b000010 : begin
             casex(IREQ)
               6'bxxxx1x : SEL_REQ = 6'b000010;
               6'bxxx10x : SEL_REQ = 6'b000100;
               6'bxx100x : SEL_REQ = 6'b001000;
               6'bx1000x : SEL_REQ = 6'b010000;
               6'b10000x : SEL_REQ = 6'b100000;
               6'b000001 : SEL_REQ = 6'b000001;
               default : SEL_REQ = 6'b0;
             endcase
           end
           6'b000100 : begin
             casex(IREQ)
               6'bxxx1xx : SEL_REQ = 6'b000100;
               6'bxx10xx : SEL_REQ = 6'b001000;
               6'bx100xx : SEL_REQ = 6'b010000;
               6'b1000xx : SEL_REQ = 6'b100000;
               6'b0000x1 : SEL_REQ = 6'b000001;
               6'b000010 : SEL_REQ = 6'b000010;
               default : SEL_REQ = 6'b0;
             endcase
           end
           6'b001000 : begin
             casex(IREQ)
               6'bxx1xxx : SEL_REQ = 6'b001000;
               6'bx10xxx : SEL_REQ = 6'b010000;
               6'b100xxx : SEL_REQ = 6'b100000;
               6'b000xx1 : SEL_REQ = 6'b000001;
               6'b000x10 : SEL_REQ = 6'b000010;
               6'b000100 : SEL_REQ = 6'b000100;
               default : SEL_REQ = 6'b0;
             endcase
           end
           6'b010000 : begin
             casex(IREQ)
               6'bx1xxxx : SEL_REQ = 6'b010000;
               6'b10xxxx : SEL_REQ = 6'b100000;
               6'b00xxx1 : SEL_REQ = 6'b000001;
               6'b00xx10 : SEL_REQ = 6'b000010;
               6'b00x100 : SEL_REQ = 6'b000100;
               6'b001000 : SEL_REQ = 6'b001000;
               default : SEL_REQ = 6'b0;
             endcase
           end
           6'b100000 : begin
             casex(IREQ)
               6'b1xxxxx : SEL_REQ = 6'b100000;
               6'b0xxxx1 : SEL_REQ = 6'b000001;
               6'b0xxx10 : SEL_REQ = 6'b000010;
               6'b0xx100 : SEL_REQ = 6'b000100;
               6'b0x1000 : SEL_REQ = 6'b001000;
               6'b010000 : SEL_REQ = 6'b010000;
               default : SEL_REQ = 6'b0;
             endcase
           end
           default : SEL_REQ = 6'b0;
         endcase // casex(PRI)
      end
   endfunction // SEL_REQ


   always@(posedge CLK) begin
      if(RST) begin
         SEL      <= 6'b0;
         STATE    <= 1'b0;
         PRIORITY <= 6'b000001;
      end
      else begin
         if(~STATE) begin
            if(|REQ) begin
               STATE <= 1'b1;
            end
            SEL <= SEL_REQ(PRIORITY, REQ);
         end
         else begin
            if(PURGE) begin
               if(~|REQ) begin
                  SEL   <= 6'b0;
                  STATE <= 1'b0;
               end
               else begin
                  SEL <= SEL_REQ(PRIORITY, REQ);
               end
               PRIORITY <= {PRIORITY[4:0], PRIORITY[5]};
            end
         end // else: !if(~STATE)
      end // else: !if(RST)
   end // always@ (posedge CLK)

endmodule // arbitor6
