/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"
module arbiter20(CLK, RST,
                REQ,
                SEL,
                PURGE);

   input CLK, RST;
   input  [19 : 0]  REQ;
   output [19 : 0]  SEL;
   input         PURGE;
   
   reg [19 : 0]     PRIORITY;
   reg [19 : 0]     SEL;
   reg           STATE;

   function [19:0] SEL_REQ;
      input [19:0] PRI;
      input [19:0] IREQ;
      begin
         casex(PRI)
           20'b00000000000000000001 : begin
             casex(IREQ)
               20'bxxxxxxxxxxxxxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'bxxxxxxxxxxxxxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'bxxxxxxxxxxxxxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'bxxxxxxxxxxxxxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'bxxxxxxxxxxxxxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'bxxxxxxxxxxxxxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'bxxxxxxxxxxxxx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'bxxxxxxxxxxxx10000000 : SEL_REQ = 20'b00000000000010000000;
               20'bxxxxxxxxxxx100000000 : SEL_REQ = 20'b00000000000100000000;
               20'bxxxxxxxxxx1000000000 : SEL_REQ = 20'b00000000001000000000;
               20'bxxxxxxxxx10000000000 : SEL_REQ = 20'b00000000010000000000;
               20'bxxxxxxxx100000000000 : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx1000000000000 : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx10000000000000 : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx100000000000000 : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx1000000000000000 : SEL_REQ = 20'b00001000000000000000;
               20'bxxx10000000000000000 : SEL_REQ = 20'b00010000000000000000;
               20'bxx100000000000000000 : SEL_REQ = 20'b00100000000000000000;
               20'bx1000000000000000000 : SEL_REQ = 20'b01000000000000000000;
               20'b10000000000000000000 : SEL_REQ = 20'b10000000000000000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000000000000000010 : begin
             casex(IREQ)
               20'bxxxxxxxxxxxxxxxxxx1x : SEL_REQ = 20'b00000000000000000010;
               20'bxxxxxxxxxxxxxxxxx10x : SEL_REQ = 20'b00000000000000000100;
               20'bxxxxxxxxxxxxxxxx100x : SEL_REQ = 20'b00000000000000001000;
               20'bxxxxxxxxxxxxxxx1000x : SEL_REQ = 20'b00000000000000010000;
               20'bxxxxxxxxxxxxxx10000x : SEL_REQ = 20'b00000000000000100000;
               20'bxxxxxxxxxxxxx100000x : SEL_REQ = 20'b00000000000001000000;
               20'bxxxxxxxxxxxx1000000x : SEL_REQ = 20'b00000000000010000000;
               20'bxxxxxxxxxxx10000000x : SEL_REQ = 20'b00000000000100000000;
               20'bxxxxxxxxxx100000000x : SEL_REQ = 20'b00000000001000000000;
               20'bxxxxxxxxx1000000000x : SEL_REQ = 20'b00000000010000000000;
               20'bxxxxxxxx10000000000x : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx100000000000x : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx1000000000000x : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx10000000000000x : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx100000000000000x : SEL_REQ = 20'b00001000000000000000;
               20'bxxx1000000000000000x : SEL_REQ = 20'b00010000000000000000;
               20'bxx10000000000000000x : SEL_REQ = 20'b00100000000000000000;
               20'bx100000000000000000x : SEL_REQ = 20'b01000000000000000000;
               20'b1000000000000000000x : SEL_REQ = 20'b10000000000000000000;
               20'b00000000000000000001 : SEL_REQ = 20'b00000000000000000001;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000000000000000100 : begin
             casex(IREQ)
               20'bxxxxxxxxxxxxxxxxx1xx : SEL_REQ = 20'b00000000000000000100;
               20'bxxxxxxxxxxxxxxxx10xx : SEL_REQ = 20'b00000000000000001000;
               20'bxxxxxxxxxxxxxxx100xx : SEL_REQ = 20'b00000000000000010000;
               20'bxxxxxxxxxxxxxx1000xx : SEL_REQ = 20'b00000000000000100000;
               20'bxxxxxxxxxxxxx10000xx : SEL_REQ = 20'b00000000000001000000;
               20'bxxxxxxxxxxxx100000xx : SEL_REQ = 20'b00000000000010000000;
               20'bxxxxxxxxxxx1000000xx : SEL_REQ = 20'b00000000000100000000;
               20'bxxxxxxxxxx10000000xx : SEL_REQ = 20'b00000000001000000000;
               20'bxxxxxxxxx100000000xx : SEL_REQ = 20'b00000000010000000000;
               20'bxxxxxxxx1000000000xx : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx10000000000xx : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx100000000000xx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx1000000000000xx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx10000000000000xx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx100000000000000xx : SEL_REQ = 20'b00010000000000000000;
               20'bxx1000000000000000xx : SEL_REQ = 20'b00100000000000000000;
               20'bx10000000000000000xx : SEL_REQ = 20'b01000000000000000000;
               20'b100000000000000000xx : SEL_REQ = 20'b10000000000000000000;
               20'b000000000000000000x1 : SEL_REQ = 20'b00000000000000000001;
               20'b00000000000000000010 : SEL_REQ = 20'b00000000000000000010;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000000000000001000 : begin
             casex(IREQ)
               20'bxxxxxxxxxxxxxxxx1xxx : SEL_REQ = 20'b00000000000000001000;
               20'bxxxxxxxxxxxxxxx10xxx : SEL_REQ = 20'b00000000000000010000;
               20'bxxxxxxxxxxxxxx100xxx : SEL_REQ = 20'b00000000000000100000;
               20'bxxxxxxxxxxxxx1000xxx : SEL_REQ = 20'b00000000000001000000;
               20'bxxxxxxxxxxxx10000xxx : SEL_REQ = 20'b00000000000010000000;
               20'bxxxxxxxxxxx100000xxx : SEL_REQ = 20'b00000000000100000000;
               20'bxxxxxxxxxx1000000xxx : SEL_REQ = 20'b00000000001000000000;
               20'bxxxxxxxxx10000000xxx : SEL_REQ = 20'b00000000010000000000;
               20'bxxxxxxxx100000000xxx : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx1000000000xxx : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx10000000000xxx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx100000000000xxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx1000000000000xxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx10000000000000xxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx100000000000000xxx : SEL_REQ = 20'b00100000000000000000;
               20'bx1000000000000000xxx : SEL_REQ = 20'b01000000000000000000;
               20'b10000000000000000xxx : SEL_REQ = 20'b10000000000000000000;
               20'b00000000000000000xx1 : SEL_REQ = 20'b00000000000000000001;
               20'b00000000000000000x10 : SEL_REQ = 20'b00000000000000000010;
               20'b00000000000000000100 : SEL_REQ = 20'b00000000000000000100;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000000000000010000 : begin
             casex(IREQ)
               20'bxxxxxxxxxxxxxxx1xxxx : SEL_REQ = 20'b00000000000000010000;
               20'bxxxxxxxxxxxxxx10xxxx : SEL_REQ = 20'b00000000000000100000;
               20'bxxxxxxxxxxxxx100xxxx : SEL_REQ = 20'b00000000000001000000;
               20'bxxxxxxxxxxxx1000xxxx : SEL_REQ = 20'b00000000000010000000;
               20'bxxxxxxxxxxx10000xxxx : SEL_REQ = 20'b00000000000100000000;
               20'bxxxxxxxxxx100000xxxx : SEL_REQ = 20'b00000000001000000000;
               20'bxxxxxxxxx1000000xxxx : SEL_REQ = 20'b00000000010000000000;
               20'bxxxxxxxx10000000xxxx : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx100000000xxxx : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx1000000000xxxx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx10000000000xxxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx100000000000xxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx1000000000000xxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx10000000000000xxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx100000000000000xxxx : SEL_REQ = 20'b01000000000000000000;
               20'b1000000000000000xxxx : SEL_REQ = 20'b10000000000000000000;
               20'b0000000000000000xxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b0000000000000000xx10 : SEL_REQ = 20'b00000000000000000010;
               20'b0000000000000000x100 : SEL_REQ = 20'b00000000000000000100;
               20'b00000000000000001000 : SEL_REQ = 20'b00000000000000001000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000000000000100000 : begin
             casex(IREQ)
               20'bxxxxxxxxxxxxxx1xxxxx : SEL_REQ = 20'b00000000000000100000;
               20'bxxxxxxxxxxxxx10xxxxx : SEL_REQ = 20'b00000000000001000000;
               20'bxxxxxxxxxxxx100xxxxx : SEL_REQ = 20'b00000000000010000000;
               20'bxxxxxxxxxxx1000xxxxx : SEL_REQ = 20'b00000000000100000000;
               20'bxxxxxxxxxx10000xxxxx : SEL_REQ = 20'b00000000001000000000;
               20'bxxxxxxxxx100000xxxxx : SEL_REQ = 20'b00000000010000000000;
               20'bxxxxxxxx1000000xxxxx : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx10000000xxxxx : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx100000000xxxxx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx1000000000xxxxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx10000000000xxxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx100000000000xxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx1000000000000xxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx10000000000000xxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b100000000000000xxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b000000000000000xxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b000000000000000xxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b000000000000000xx100 : SEL_REQ = 20'b00000000000000000100;
               20'b000000000000000x1000 : SEL_REQ = 20'b00000000000000001000;
               20'b00000000000000010000 : SEL_REQ = 20'b00000000000000010000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000000000001000000 : begin
             casex(IREQ)
               20'bxxxxxxxxxxxxx1xxxxxx : SEL_REQ = 20'b00000000000001000000;
               20'bxxxxxxxxxxxx10xxxxxx : SEL_REQ = 20'b00000000000010000000;
               20'bxxxxxxxxxxx100xxxxxx : SEL_REQ = 20'b00000000000100000000;
               20'bxxxxxxxxxx1000xxxxxx : SEL_REQ = 20'b00000000001000000000;
               20'bxxxxxxxxx10000xxxxxx : SEL_REQ = 20'b00000000010000000000;
               20'bxxxxxxxx100000xxxxxx : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx1000000xxxxxx : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx10000000xxxxxx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx100000000xxxxxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx1000000000xxxxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx10000000000xxxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx100000000000xxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx1000000000000xxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b10000000000000xxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b00000000000000xxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b00000000000000xxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b00000000000000xxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b00000000000000xx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b00000000000000x10000 : SEL_REQ = 20'b00000000000000010000;
               20'b00000000000000100000 : SEL_REQ = 20'b00000000000000100000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000000000010000000 : begin
             casex(IREQ)
               20'bxxxxxxxxxxxx1xxxxxxx : SEL_REQ = 20'b00000000000010000000;
               20'bxxxxxxxxxxx10xxxxxxx : SEL_REQ = 20'b00000000000100000000;
               20'bxxxxxxxxxx100xxxxxxx : SEL_REQ = 20'b00000000001000000000;
               20'bxxxxxxxxx1000xxxxxxx : SEL_REQ = 20'b00000000010000000000;
               20'bxxxxxxxx10000xxxxxxx : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx100000xxxxxxx : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx1000000xxxxxxx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx10000000xxxxxxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx100000000xxxxxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx1000000000xxxxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx10000000000xxxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx100000000000xxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b1000000000000xxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b0000000000000xxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b0000000000000xxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b0000000000000xxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b0000000000000xxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b0000000000000xx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b0000000000000x100000 : SEL_REQ = 20'b00000000000000100000;
               20'b00000000000001000000 : SEL_REQ = 20'b00000000000001000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000000000100000000 : begin
             casex(IREQ)
               20'bxxxxxxxxxxx1xxxxxxxx : SEL_REQ = 20'b00000000000100000000;
               20'bxxxxxxxxxx10xxxxxxxx : SEL_REQ = 20'b00000000001000000000;
               20'bxxxxxxxxx100xxxxxxxx : SEL_REQ = 20'b00000000010000000000;
               20'bxxxxxxxx1000xxxxxxxx : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx10000xxxxxxxx : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx100000xxxxxxxx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx1000000xxxxxxxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx10000000xxxxxxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx100000000xxxxxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx1000000000xxxxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx10000000000xxxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b100000000000xxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b000000000000xxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b000000000000xxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b000000000000xxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b000000000000xxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b000000000000xxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b000000000000xx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b000000000000x1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b00000000000010000000 : SEL_REQ = 20'b00000000000010000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000000001000000000 : begin
             casex(IREQ)
               20'bxxxxxxxxxx1xxxxxxxxx : SEL_REQ = 20'b00000000001000000000;
               20'bxxxxxxxxx10xxxxxxxxx : SEL_REQ = 20'b00000000010000000000;
               20'bxxxxxxxx100xxxxxxxxx : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx1000xxxxxxxxx : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx10000xxxxxxxxx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx100000xxxxxxxxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx1000000xxxxxxxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx10000000xxxxxxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx100000000xxxxxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx1000000000xxxxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b10000000000xxxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b00000000000xxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b00000000000xxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b00000000000xxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b00000000000xxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b00000000000xxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b00000000000xxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b00000000000xx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b00000000000x10000000 : SEL_REQ = 20'b00000000000010000000;
               20'b00000000000100000000 : SEL_REQ = 20'b00000000000100000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000000010000000000 : begin
             casex(IREQ)
               20'bxxxxxxxxx1xxxxxxxxxx : SEL_REQ = 20'b00000000010000000000;
               20'bxxxxxxxx10xxxxxxxxxx : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx100xxxxxxxxxx : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx1000xxxxxxxxxx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx10000xxxxxxxxxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx100000xxxxxxxxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx1000000xxxxxxxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx10000000xxxxxxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx100000000xxxxxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b1000000000xxxxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b0000000000xxxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b0000000000xxxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b0000000000xxxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b0000000000xxxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b0000000000xxxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b0000000000xxxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b0000000000xxx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b0000000000xx10000000 : SEL_REQ = 20'b00000000000010000000;
               20'b0000000000x100000000 : SEL_REQ = 20'b00000000000100000000;
               20'b00000000001000000000 : SEL_REQ = 20'b00000000001000000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000000100000000000 : begin
             casex(IREQ)
               20'bxxxxxxxx1xxxxxxxxxxx : SEL_REQ = 20'b00000000100000000000;
               20'bxxxxxxx10xxxxxxxxxxx : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx100xxxxxxxxxxx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx1000xxxxxxxxxxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx10000xxxxxxxxxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx100000xxxxxxxxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx1000000xxxxxxxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx10000000xxxxxxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b100000000xxxxxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b000000000xxxxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b000000000xxxxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b000000000xxxxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b000000000xxxxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b000000000xxxxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b000000000xxxxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b000000000xxxx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b000000000xxx10000000 : SEL_REQ = 20'b00000000000010000000;
               20'b000000000xx100000000 : SEL_REQ = 20'b00000000000100000000;
               20'b000000000x1000000000 : SEL_REQ = 20'b00000000001000000000;
               20'b00000000010000000000 : SEL_REQ = 20'b00000000010000000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000001000000000000 : begin
             casex(IREQ)
               20'bxxxxxxx1xxxxxxxxxxxx : SEL_REQ = 20'b00000001000000000000;
               20'bxxxxxx10xxxxxxxxxxxx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx100xxxxxxxxxxxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx1000xxxxxxxxxxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx10000xxxxxxxxxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx100000xxxxxxxxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx1000000xxxxxxxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b10000000xxxxxxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b00000000xxxxxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b00000000xxxxxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b00000000xxxxxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b00000000xxxxxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b00000000xxxxxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b00000000xxxxxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b00000000xxxxx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b00000000xxxx10000000 : SEL_REQ = 20'b00000000000010000000;
               20'b00000000xxx100000000 : SEL_REQ = 20'b00000000000100000000;
               20'b00000000xx1000000000 : SEL_REQ = 20'b00000000001000000000;
               20'b00000000x10000000000 : SEL_REQ = 20'b00000000010000000000;
               20'b00000000100000000000 : SEL_REQ = 20'b00000000100000000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000010000000000000 : begin
             casex(IREQ)
               20'bxxxxxx1xxxxxxxxxxxxx : SEL_REQ = 20'b00000010000000000000;
               20'bxxxxx10xxxxxxxxxxxxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx100xxxxxxxxxxxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx1000xxxxxxxxxxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx10000xxxxxxxxxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx100000xxxxxxxxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b1000000xxxxxxxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b0000000xxxxxxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b0000000xxxxxxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b0000000xxxxxxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b0000000xxxxxxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b0000000xxxxxxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b0000000xxxxxxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b0000000xxxxxx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b0000000xxxxx10000000 : SEL_REQ = 20'b00000000000010000000;
               20'b0000000xxxx100000000 : SEL_REQ = 20'b00000000000100000000;
               20'b0000000xxx1000000000 : SEL_REQ = 20'b00000000001000000000;
               20'b0000000xx10000000000 : SEL_REQ = 20'b00000000010000000000;
               20'b0000000x100000000000 : SEL_REQ = 20'b00000000100000000000;
               20'b00000001000000000000 : SEL_REQ = 20'b00000001000000000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00000100000000000000 : begin
             casex(IREQ)
               20'bxxxxx1xxxxxxxxxxxxxx : SEL_REQ = 20'b00000100000000000000;
               20'bxxxx10xxxxxxxxxxxxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx100xxxxxxxxxxxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx1000xxxxxxxxxxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx10000xxxxxxxxxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b100000xxxxxxxxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b000000xxxxxxxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b000000xxxxxxxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b000000xxxxxxxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b000000xxxxxxxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b000000xxxxxxxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b000000xxxxxxxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b000000xxxxxxx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b000000xxxxxx10000000 : SEL_REQ = 20'b00000000000010000000;
               20'b000000xxxxx100000000 : SEL_REQ = 20'b00000000000100000000;
               20'b000000xxxx1000000000 : SEL_REQ = 20'b00000000001000000000;
               20'b000000xxx10000000000 : SEL_REQ = 20'b00000000010000000000;
               20'b000000xx100000000000 : SEL_REQ = 20'b00000000100000000000;
               20'b000000x1000000000000 : SEL_REQ = 20'b00000001000000000000;
               20'b00000010000000000000 : SEL_REQ = 20'b00000010000000000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00001000000000000000 : begin
             casex(IREQ)
               20'bxxxx1xxxxxxxxxxxxxxx : SEL_REQ = 20'b00001000000000000000;
               20'bxxx10xxxxxxxxxxxxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx100xxxxxxxxxxxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx1000xxxxxxxxxxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b10000xxxxxxxxxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b00000xxxxxxxxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b00000xxxxxxxxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b00000xxxxxxxxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b00000xxxxxxxxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b00000xxxxxxxxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b00000xxxxxxxxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b00000xxxxxxxx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b00000xxxxxxx10000000 : SEL_REQ = 20'b00000000000010000000;
               20'b00000xxxxxx100000000 : SEL_REQ = 20'b00000000000100000000;
               20'b00000xxxxx1000000000 : SEL_REQ = 20'b00000000001000000000;
               20'b00000xxxx10000000000 : SEL_REQ = 20'b00000000010000000000;
               20'b00000xxx100000000000 : SEL_REQ = 20'b00000000100000000000;
               20'b00000xx1000000000000 : SEL_REQ = 20'b00000001000000000000;
               20'b00000x10000000000000 : SEL_REQ = 20'b00000010000000000000;
               20'b00000100000000000000 : SEL_REQ = 20'b00000100000000000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00010000000000000000 : begin
             casex(IREQ)
               20'bxxx1xxxxxxxxxxxxxxxx : SEL_REQ = 20'b00010000000000000000;
               20'bxx10xxxxxxxxxxxxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx100xxxxxxxxxxxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b1000xxxxxxxxxxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b0000xxxxxxxxxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b0000xxxxxxxxxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b0000xxxxxxxxxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b0000xxxxxxxxxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b0000xxxxxxxxxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b0000xxxxxxxxxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b0000xxxxxxxxx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b0000xxxxxxxx10000000 : SEL_REQ = 20'b00000000000010000000;
               20'b0000xxxxxxx100000000 : SEL_REQ = 20'b00000000000100000000;
               20'b0000xxxxxx1000000000 : SEL_REQ = 20'b00000000001000000000;
               20'b0000xxxxx10000000000 : SEL_REQ = 20'b00000000010000000000;
               20'b0000xxxx100000000000 : SEL_REQ = 20'b00000000100000000000;
               20'b0000xxx1000000000000 : SEL_REQ = 20'b00000001000000000000;
               20'b0000xx10000000000000 : SEL_REQ = 20'b00000010000000000000;
               20'b0000x100000000000000 : SEL_REQ = 20'b00000100000000000000;
               20'b00001000000000000000 : SEL_REQ = 20'b00001000000000000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b00100000000000000000 : begin
             casex(IREQ)
               20'bxx1xxxxxxxxxxxxxxxxx : SEL_REQ = 20'b00100000000000000000;
               20'bx10xxxxxxxxxxxxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b100xxxxxxxxxxxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b000xxxxxxxxxxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b000xxxxxxxxxxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b000xxxxxxxxxxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b000xxxxxxxxxxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b000xxxxxxxxxxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b000xxxxxxxxxxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b000xxxxxxxxxx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b000xxxxxxxxx10000000 : SEL_REQ = 20'b00000000000010000000;
               20'b000xxxxxxxx100000000 : SEL_REQ = 20'b00000000000100000000;
               20'b000xxxxxxx1000000000 : SEL_REQ = 20'b00000000001000000000;
               20'b000xxxxxx10000000000 : SEL_REQ = 20'b00000000010000000000;
               20'b000xxxxx100000000000 : SEL_REQ = 20'b00000000100000000000;
               20'b000xxxx1000000000000 : SEL_REQ = 20'b00000001000000000000;
               20'b000xxx10000000000000 : SEL_REQ = 20'b00000010000000000000;
               20'b000xx100000000000000 : SEL_REQ = 20'b00000100000000000000;
               20'b000x1000000000000000 : SEL_REQ = 20'b00001000000000000000;
               20'b00010000000000000000 : SEL_REQ = 20'b00010000000000000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b01000000000000000000 : begin
             casex(IREQ)
               20'bx1xxxxxxxxxxxxxxxxxx : SEL_REQ = 20'b01000000000000000000;
               20'b10xxxxxxxxxxxxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b00xxxxxxxxxxxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b00xxxxxxxxxxxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b00xxxxxxxxxxxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b00xxxxxxxxxxxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b00xxxxxxxxxxxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b00xxxxxxxxxxxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b00xxxxxxxxxxx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b00xxxxxxxxxx10000000 : SEL_REQ = 20'b00000000000010000000;
               20'b00xxxxxxxxx100000000 : SEL_REQ = 20'b00000000000100000000;
               20'b00xxxxxxxx1000000000 : SEL_REQ = 20'b00000000001000000000;
               20'b00xxxxxxx10000000000 : SEL_REQ = 20'b00000000010000000000;
               20'b00xxxxxx100000000000 : SEL_REQ = 20'b00000000100000000000;
               20'b00xxxxx1000000000000 : SEL_REQ = 20'b00000001000000000000;
               20'b00xxxx10000000000000 : SEL_REQ = 20'b00000010000000000000;
               20'b00xxx100000000000000 : SEL_REQ = 20'b00000100000000000000;
               20'b00xx1000000000000000 : SEL_REQ = 20'b00001000000000000000;
               20'b00x10000000000000000 : SEL_REQ = 20'b00010000000000000000;
               20'b00100000000000000000 : SEL_REQ = 20'b00100000000000000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           20'b10000000000000000000 : begin
             casex(IREQ)
               20'b1xxxxxxxxxxxxxxxxxxx : SEL_REQ = 20'b10000000000000000000;
               20'b0xxxxxxxxxxxxxxxxxx1 : SEL_REQ = 20'b00000000000000000001;
               20'b0xxxxxxxxxxxxxxxxx10 : SEL_REQ = 20'b00000000000000000010;
               20'b0xxxxxxxxxxxxxxxx100 : SEL_REQ = 20'b00000000000000000100;
               20'b0xxxxxxxxxxxxxxx1000 : SEL_REQ = 20'b00000000000000001000;
               20'b0xxxxxxxxxxxxxx10000 : SEL_REQ = 20'b00000000000000010000;
               20'b0xxxxxxxxxxxxx100000 : SEL_REQ = 20'b00000000000000100000;
               20'b0xxxxxxxxxxxx1000000 : SEL_REQ = 20'b00000000000001000000;
               20'b0xxxxxxxxxxx10000000 : SEL_REQ = 20'b00000000000010000000;
               20'b0xxxxxxxxxx100000000 : SEL_REQ = 20'b00000000000100000000;
               20'b0xxxxxxxxx1000000000 : SEL_REQ = 20'b00000000001000000000;
               20'b0xxxxxxxx10000000000 : SEL_REQ = 20'b00000000010000000000;
               20'b0xxxxxxx100000000000 : SEL_REQ = 20'b00000000100000000000;
               20'b0xxxxxx1000000000000 : SEL_REQ = 20'b00000001000000000000;
               20'b0xxxxx10000000000000 : SEL_REQ = 20'b00000010000000000000;
               20'b0xxxx100000000000000 : SEL_REQ = 20'b00000100000000000000;
               20'b0xxx1000000000000000 : SEL_REQ = 20'b00001000000000000000;
               20'b0xx10000000000000000 : SEL_REQ = 20'b00010000000000000000;
               20'b0x100000000000000000 : SEL_REQ = 20'b00100000000000000000;
               20'b01000000000000000000 : SEL_REQ = 20'b01000000000000000000;
               default : SEL_REQ = 20'b0;
             endcase
           end
           default : SEL_REQ = 20'b0;
         endcase // casex(PRI)
      end
   endfunction // SEL_REQ


   always@(posedge CLK) begin
      if(RST) begin
         SEL      <= 20'b0;
         STATE    <= 1'b0;
         PRIORITY <= 20'b00000000000000000001;
      end
      else begin
         if(~STATE) begin
            if(|REQ) begin
               STATE <= 1'b1;
            end
            SEL <= SEL_REQ(PRIORITY, REQ);
         end
         else begin
            if(PURGE) begin
               if(~|REQ) begin
                  SEL   <= 20'b0;
                  STATE <= 1'b0;
               end
               else begin
                  SEL <= SEL_REQ(PRIORITY, REQ);
               end
               PRIORITY <= {PRIORITY[18:0], PRIORITY[19]};
            end
         end // else: !if(~STATE)
      end // else: !if(RST)
   end // always@ (posedge CLK)

endmodule // arbitor20
