/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"
module arbiter16(CLK, RST,
                REQ,
                SEL,
                PURGE);

   input CLK, RST;
   input  [15 : 0]  REQ;
   output [15 : 0]  SEL;
   input         PURGE;
   
   reg [15 : 0]     PRIORITY;
   reg [15 : 0]     SEL;
   reg           STATE;

   function [15:0] SEL_REQ;
      input [15:0] PRI;
      input [15:0] IREQ;
      begin
         casex(PRI)
           16'b0000000000000001 : begin
             casex(IREQ)
               16'bxxxxxxxxxxxxxxx1 : SEL_REQ = 16'b0000000000000001;
               16'bxxxxxxxxxxxxxx10 : SEL_REQ = 16'b0000000000000010;
               16'bxxxxxxxxxxxxx100 : SEL_REQ = 16'b0000000000000100;
               16'bxxxxxxxxxxxx1000 : SEL_REQ = 16'b0000000000001000;
               16'bxxxxxxxxxxx10000 : SEL_REQ = 16'b0000000000010000;
               16'bxxxxxxxxxx100000 : SEL_REQ = 16'b0000000000100000;
               16'bxxxxxxxxx1000000 : SEL_REQ = 16'b0000000001000000;
               16'bxxxxxxxx10000000 : SEL_REQ = 16'b0000000010000000;
               16'bxxxxxxx100000000 : SEL_REQ = 16'b0000000100000000;
               16'bxxxxxx1000000000 : SEL_REQ = 16'b0000001000000000;
               16'bxxxxx10000000000 : SEL_REQ = 16'b0000010000000000;
               16'bxxxx100000000000 : SEL_REQ = 16'b0000100000000000;
               16'bxxx1000000000000 : SEL_REQ = 16'b0001000000000000;
               16'bxx10000000000000 : SEL_REQ = 16'b0010000000000000;
               16'bx100000000000000 : SEL_REQ = 16'b0100000000000000;
               16'b1000000000000000 : SEL_REQ = 16'b1000000000000000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0000000000000010 : begin
             casex(IREQ)
               16'bxxxxxxxxxxxxxx1x : SEL_REQ = 16'b0000000000000010;
               16'bxxxxxxxxxxxxx10x : SEL_REQ = 16'b0000000000000100;
               16'bxxxxxxxxxxxx100x : SEL_REQ = 16'b0000000000001000;
               16'bxxxxxxxxxxx1000x : SEL_REQ = 16'b0000000000010000;
               16'bxxxxxxxxxx10000x : SEL_REQ = 16'b0000000000100000;
               16'bxxxxxxxxx100000x : SEL_REQ = 16'b0000000001000000;
               16'bxxxxxxxx1000000x : SEL_REQ = 16'b0000000010000000;
               16'bxxxxxxx10000000x : SEL_REQ = 16'b0000000100000000;
               16'bxxxxxx100000000x : SEL_REQ = 16'b0000001000000000;
               16'bxxxxx1000000000x : SEL_REQ = 16'b0000010000000000;
               16'bxxxx10000000000x : SEL_REQ = 16'b0000100000000000;
               16'bxxx100000000000x : SEL_REQ = 16'b0001000000000000;
               16'bxx1000000000000x : SEL_REQ = 16'b0010000000000000;
               16'bx10000000000000x : SEL_REQ = 16'b0100000000000000;
               16'b100000000000000x : SEL_REQ = 16'b1000000000000000;
               16'b0000000000000001 : SEL_REQ = 16'b0000000000000001;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0000000000000100 : begin
             casex(IREQ)
               16'bxxxxxxxxxxxxx1xx : SEL_REQ = 16'b0000000000000100;
               16'bxxxxxxxxxxxx10xx : SEL_REQ = 16'b0000000000001000;
               16'bxxxxxxxxxxx100xx : SEL_REQ = 16'b0000000000010000;
               16'bxxxxxxxxxx1000xx : SEL_REQ = 16'b0000000000100000;
               16'bxxxxxxxxx10000xx : SEL_REQ = 16'b0000000001000000;
               16'bxxxxxxxx100000xx : SEL_REQ = 16'b0000000010000000;
               16'bxxxxxxx1000000xx : SEL_REQ = 16'b0000000100000000;
               16'bxxxxxx10000000xx : SEL_REQ = 16'b0000001000000000;
               16'bxxxxx100000000xx : SEL_REQ = 16'b0000010000000000;
               16'bxxxx1000000000xx : SEL_REQ = 16'b0000100000000000;
               16'bxxx10000000000xx : SEL_REQ = 16'b0001000000000000;
               16'bxx100000000000xx : SEL_REQ = 16'b0010000000000000;
               16'bx1000000000000xx : SEL_REQ = 16'b0100000000000000;
               16'b10000000000000xx : SEL_REQ = 16'b1000000000000000;
               16'b00000000000000x1 : SEL_REQ = 16'b0000000000000001;
               16'b0000000000000010 : SEL_REQ = 16'b0000000000000010;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0000000000001000 : begin
             casex(IREQ)
               16'bxxxxxxxxxxxx1xxx : SEL_REQ = 16'b0000000000001000;
               16'bxxxxxxxxxxx10xxx : SEL_REQ = 16'b0000000000010000;
               16'bxxxxxxxxxx100xxx : SEL_REQ = 16'b0000000000100000;
               16'bxxxxxxxxx1000xxx : SEL_REQ = 16'b0000000001000000;
               16'bxxxxxxxx10000xxx : SEL_REQ = 16'b0000000010000000;
               16'bxxxxxxx100000xxx : SEL_REQ = 16'b0000000100000000;
               16'bxxxxxx1000000xxx : SEL_REQ = 16'b0000001000000000;
               16'bxxxxx10000000xxx : SEL_REQ = 16'b0000010000000000;
               16'bxxxx100000000xxx : SEL_REQ = 16'b0000100000000000;
               16'bxxx1000000000xxx : SEL_REQ = 16'b0001000000000000;
               16'bxx10000000000xxx : SEL_REQ = 16'b0010000000000000;
               16'bx100000000000xxx : SEL_REQ = 16'b0100000000000000;
               16'b1000000000000xxx : SEL_REQ = 16'b1000000000000000;
               16'b0000000000000xx1 : SEL_REQ = 16'b0000000000000001;
               16'b0000000000000x10 : SEL_REQ = 16'b0000000000000010;
               16'b0000000000000100 : SEL_REQ = 16'b0000000000000100;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0000000000010000 : begin
             casex(IREQ)
               16'bxxxxxxxxxxx1xxxx : SEL_REQ = 16'b0000000000010000;
               16'bxxxxxxxxxx10xxxx : SEL_REQ = 16'b0000000000100000;
               16'bxxxxxxxxx100xxxx : SEL_REQ = 16'b0000000001000000;
               16'bxxxxxxxx1000xxxx : SEL_REQ = 16'b0000000010000000;
               16'bxxxxxxx10000xxxx : SEL_REQ = 16'b0000000100000000;
               16'bxxxxxx100000xxxx : SEL_REQ = 16'b0000001000000000;
               16'bxxxxx1000000xxxx : SEL_REQ = 16'b0000010000000000;
               16'bxxxx10000000xxxx : SEL_REQ = 16'b0000100000000000;
               16'bxxx100000000xxxx : SEL_REQ = 16'b0001000000000000;
               16'bxx1000000000xxxx : SEL_REQ = 16'b0010000000000000;
               16'bx10000000000xxxx : SEL_REQ = 16'b0100000000000000;
               16'b100000000000xxxx : SEL_REQ = 16'b1000000000000000;
               16'b000000000000xxx1 : SEL_REQ = 16'b0000000000000001;
               16'b000000000000xx10 : SEL_REQ = 16'b0000000000000010;
               16'b000000000000x100 : SEL_REQ = 16'b0000000000000100;
               16'b0000000000001000 : SEL_REQ = 16'b0000000000001000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0000000000100000 : begin
             casex(IREQ)
               16'bxxxxxxxxxx1xxxxx : SEL_REQ = 16'b0000000000100000;
               16'bxxxxxxxxx10xxxxx : SEL_REQ = 16'b0000000001000000;
               16'bxxxxxxxx100xxxxx : SEL_REQ = 16'b0000000010000000;
               16'bxxxxxxx1000xxxxx : SEL_REQ = 16'b0000000100000000;
               16'bxxxxxx10000xxxxx : SEL_REQ = 16'b0000001000000000;
               16'bxxxxx100000xxxxx : SEL_REQ = 16'b0000010000000000;
               16'bxxxx1000000xxxxx : SEL_REQ = 16'b0000100000000000;
               16'bxxx10000000xxxxx : SEL_REQ = 16'b0001000000000000;
               16'bxx100000000xxxxx : SEL_REQ = 16'b0010000000000000;
               16'bx1000000000xxxxx : SEL_REQ = 16'b0100000000000000;
               16'b10000000000xxxxx : SEL_REQ = 16'b1000000000000000;
               16'b00000000000xxxx1 : SEL_REQ = 16'b0000000000000001;
               16'b00000000000xxx10 : SEL_REQ = 16'b0000000000000010;
               16'b00000000000xx100 : SEL_REQ = 16'b0000000000000100;
               16'b00000000000x1000 : SEL_REQ = 16'b0000000000001000;
               16'b0000000000010000 : SEL_REQ = 16'b0000000000010000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0000000001000000 : begin
             casex(IREQ)
               16'bxxxxxxxxx1xxxxxx : SEL_REQ = 16'b0000000001000000;
               16'bxxxxxxxx10xxxxxx : SEL_REQ = 16'b0000000010000000;
               16'bxxxxxxx100xxxxxx : SEL_REQ = 16'b0000000100000000;
               16'bxxxxxx1000xxxxxx : SEL_REQ = 16'b0000001000000000;
               16'bxxxxx10000xxxxxx : SEL_REQ = 16'b0000010000000000;
               16'bxxxx100000xxxxxx : SEL_REQ = 16'b0000100000000000;
               16'bxxx1000000xxxxxx : SEL_REQ = 16'b0001000000000000;
               16'bxx10000000xxxxxx : SEL_REQ = 16'b0010000000000000;
               16'bx100000000xxxxxx : SEL_REQ = 16'b0100000000000000;
               16'b1000000000xxxxxx : SEL_REQ = 16'b1000000000000000;
               16'b0000000000xxxxx1 : SEL_REQ = 16'b0000000000000001;
               16'b0000000000xxxx10 : SEL_REQ = 16'b0000000000000010;
               16'b0000000000xxx100 : SEL_REQ = 16'b0000000000000100;
               16'b0000000000xx1000 : SEL_REQ = 16'b0000000000001000;
               16'b0000000000x10000 : SEL_REQ = 16'b0000000000010000;
               16'b0000000000100000 : SEL_REQ = 16'b0000000000100000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0000000010000000 : begin
             casex(IREQ)
               16'bxxxxxxxx1xxxxxxx : SEL_REQ = 16'b0000000010000000;
               16'bxxxxxxx10xxxxxxx : SEL_REQ = 16'b0000000100000000;
               16'bxxxxxx100xxxxxxx : SEL_REQ = 16'b0000001000000000;
               16'bxxxxx1000xxxxxxx : SEL_REQ = 16'b0000010000000000;
               16'bxxxx10000xxxxxxx : SEL_REQ = 16'b0000100000000000;
               16'bxxx100000xxxxxxx : SEL_REQ = 16'b0001000000000000;
               16'bxx1000000xxxxxxx : SEL_REQ = 16'b0010000000000000;
               16'bx10000000xxxxxxx : SEL_REQ = 16'b0100000000000000;
               16'b100000000xxxxxxx : SEL_REQ = 16'b1000000000000000;
               16'b000000000xxxxxx1 : SEL_REQ = 16'b0000000000000001;
               16'b000000000xxxxx10 : SEL_REQ = 16'b0000000000000010;
               16'b000000000xxxx100 : SEL_REQ = 16'b0000000000000100;
               16'b000000000xxx1000 : SEL_REQ = 16'b0000000000001000;
               16'b000000000xx10000 : SEL_REQ = 16'b0000000000010000;
               16'b000000000x100000 : SEL_REQ = 16'b0000000000100000;
               16'b0000000001000000 : SEL_REQ = 16'b0000000001000000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0000000100000000 : begin
             casex(IREQ)
               16'bxxxxxxx1xxxxxxxx : SEL_REQ = 16'b0000000100000000;
               16'bxxxxxx10xxxxxxxx : SEL_REQ = 16'b0000001000000000;
               16'bxxxxx100xxxxxxxx : SEL_REQ = 16'b0000010000000000;
               16'bxxxx1000xxxxxxxx : SEL_REQ = 16'b0000100000000000;
               16'bxxx10000xxxxxxxx : SEL_REQ = 16'b0001000000000000;
               16'bxx100000xxxxxxxx : SEL_REQ = 16'b0010000000000000;
               16'bx1000000xxxxxxxx : SEL_REQ = 16'b0100000000000000;
               16'b10000000xxxxxxxx : SEL_REQ = 16'b1000000000000000;
               16'b00000000xxxxxxx1 : SEL_REQ = 16'b0000000000000001;
               16'b00000000xxxxxx10 : SEL_REQ = 16'b0000000000000010;
               16'b00000000xxxxx100 : SEL_REQ = 16'b0000000000000100;
               16'b00000000xxxx1000 : SEL_REQ = 16'b0000000000001000;
               16'b00000000xxx10000 : SEL_REQ = 16'b0000000000010000;
               16'b00000000xx100000 : SEL_REQ = 16'b0000000000100000;
               16'b00000000x1000000 : SEL_REQ = 16'b0000000001000000;
               16'b0000000010000000 : SEL_REQ = 16'b0000000010000000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0000001000000000 : begin
             casex(IREQ)
               16'bxxxxxx1xxxxxxxxx : SEL_REQ = 16'b0000001000000000;
               16'bxxxxx10xxxxxxxxx : SEL_REQ = 16'b0000010000000000;
               16'bxxxx100xxxxxxxxx : SEL_REQ = 16'b0000100000000000;
               16'bxxx1000xxxxxxxxx : SEL_REQ = 16'b0001000000000000;
               16'bxx10000xxxxxxxxx : SEL_REQ = 16'b0010000000000000;
               16'bx100000xxxxxxxxx : SEL_REQ = 16'b0100000000000000;
               16'b1000000xxxxxxxxx : SEL_REQ = 16'b1000000000000000;
               16'b0000000xxxxxxxx1 : SEL_REQ = 16'b0000000000000001;
               16'b0000000xxxxxxx10 : SEL_REQ = 16'b0000000000000010;
               16'b0000000xxxxxx100 : SEL_REQ = 16'b0000000000000100;
               16'b0000000xxxxx1000 : SEL_REQ = 16'b0000000000001000;
               16'b0000000xxxx10000 : SEL_REQ = 16'b0000000000010000;
               16'b0000000xxx100000 : SEL_REQ = 16'b0000000000100000;
               16'b0000000xx1000000 : SEL_REQ = 16'b0000000001000000;
               16'b0000000x10000000 : SEL_REQ = 16'b0000000010000000;
               16'b0000000100000000 : SEL_REQ = 16'b0000000100000000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0000010000000000 : begin
             casex(IREQ)
               16'bxxxxx1xxxxxxxxxx : SEL_REQ = 16'b0000010000000000;
               16'bxxxx10xxxxxxxxxx : SEL_REQ = 16'b0000100000000000;
               16'bxxx100xxxxxxxxxx : SEL_REQ = 16'b0001000000000000;
               16'bxx1000xxxxxxxxxx : SEL_REQ = 16'b0010000000000000;
               16'bx10000xxxxxxxxxx : SEL_REQ = 16'b0100000000000000;
               16'b100000xxxxxxxxxx : SEL_REQ = 16'b1000000000000000;
               16'b000000xxxxxxxxx1 : SEL_REQ = 16'b0000000000000001;
               16'b000000xxxxxxxx10 : SEL_REQ = 16'b0000000000000010;
               16'b000000xxxxxxx100 : SEL_REQ = 16'b0000000000000100;
               16'b000000xxxxxx1000 : SEL_REQ = 16'b0000000000001000;
               16'b000000xxxxx10000 : SEL_REQ = 16'b0000000000010000;
               16'b000000xxxx100000 : SEL_REQ = 16'b0000000000100000;
               16'b000000xxx1000000 : SEL_REQ = 16'b0000000001000000;
               16'b000000xx10000000 : SEL_REQ = 16'b0000000010000000;
               16'b000000x100000000 : SEL_REQ = 16'b0000000100000000;
               16'b0000001000000000 : SEL_REQ = 16'b0000001000000000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0000100000000000 : begin
             casex(IREQ)
               16'bxxxx1xxxxxxxxxxx : SEL_REQ = 16'b0000100000000000;
               16'bxxx10xxxxxxxxxxx : SEL_REQ = 16'b0001000000000000;
               16'bxx100xxxxxxxxxxx : SEL_REQ = 16'b0010000000000000;
               16'bx1000xxxxxxxxxxx : SEL_REQ = 16'b0100000000000000;
               16'b10000xxxxxxxxxxx : SEL_REQ = 16'b1000000000000000;
               16'b00000xxxxxxxxxx1 : SEL_REQ = 16'b0000000000000001;
               16'b00000xxxxxxxxx10 : SEL_REQ = 16'b0000000000000010;
               16'b00000xxxxxxxx100 : SEL_REQ = 16'b0000000000000100;
               16'b00000xxxxxxx1000 : SEL_REQ = 16'b0000000000001000;
               16'b00000xxxxxx10000 : SEL_REQ = 16'b0000000000010000;
               16'b00000xxxxx100000 : SEL_REQ = 16'b0000000000100000;
               16'b00000xxxx1000000 : SEL_REQ = 16'b0000000001000000;
               16'b00000xxx10000000 : SEL_REQ = 16'b0000000010000000;
               16'b00000xx100000000 : SEL_REQ = 16'b0000000100000000;
               16'b00000x1000000000 : SEL_REQ = 16'b0000001000000000;
               16'b0000010000000000 : SEL_REQ = 16'b0000010000000000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0001000000000000 : begin
             casex(IREQ)
               16'bxxx1xxxxxxxxxxxx : SEL_REQ = 16'b0001000000000000;
               16'bxx10xxxxxxxxxxxx : SEL_REQ = 16'b0010000000000000;
               16'bx100xxxxxxxxxxxx : SEL_REQ = 16'b0100000000000000;
               16'b1000xxxxxxxxxxxx : SEL_REQ = 16'b1000000000000000;
               16'b0000xxxxxxxxxxx1 : SEL_REQ = 16'b0000000000000001;
               16'b0000xxxxxxxxxx10 : SEL_REQ = 16'b0000000000000010;
               16'b0000xxxxxxxxx100 : SEL_REQ = 16'b0000000000000100;
               16'b0000xxxxxxxx1000 : SEL_REQ = 16'b0000000000001000;
               16'b0000xxxxxxx10000 : SEL_REQ = 16'b0000000000010000;
               16'b0000xxxxxx100000 : SEL_REQ = 16'b0000000000100000;
               16'b0000xxxxx1000000 : SEL_REQ = 16'b0000000001000000;
               16'b0000xxxx10000000 : SEL_REQ = 16'b0000000010000000;
               16'b0000xxx100000000 : SEL_REQ = 16'b0000000100000000;
               16'b0000xx1000000000 : SEL_REQ = 16'b0000001000000000;
               16'b0000x10000000000 : SEL_REQ = 16'b0000010000000000;
               16'b0000100000000000 : SEL_REQ = 16'b0000100000000000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0010000000000000 : begin
             casex(IREQ)
               16'bxx1xxxxxxxxxxxxx : SEL_REQ = 16'b0010000000000000;
               16'bx10xxxxxxxxxxxxx : SEL_REQ = 16'b0100000000000000;
               16'b100xxxxxxxxxxxxx : SEL_REQ = 16'b1000000000000000;
               16'b000xxxxxxxxxxxx1 : SEL_REQ = 16'b0000000000000001;
               16'b000xxxxxxxxxxx10 : SEL_REQ = 16'b0000000000000010;
               16'b000xxxxxxxxxx100 : SEL_REQ = 16'b0000000000000100;
               16'b000xxxxxxxxx1000 : SEL_REQ = 16'b0000000000001000;
               16'b000xxxxxxxx10000 : SEL_REQ = 16'b0000000000010000;
               16'b000xxxxxxx100000 : SEL_REQ = 16'b0000000000100000;
               16'b000xxxxxx1000000 : SEL_REQ = 16'b0000000001000000;
               16'b000xxxxx10000000 : SEL_REQ = 16'b0000000010000000;
               16'b000xxxx100000000 : SEL_REQ = 16'b0000000100000000;
               16'b000xxx1000000000 : SEL_REQ = 16'b0000001000000000;
               16'b000xx10000000000 : SEL_REQ = 16'b0000010000000000;
               16'b000x100000000000 : SEL_REQ = 16'b0000100000000000;
               16'b0001000000000000 : SEL_REQ = 16'b0001000000000000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b0100000000000000 : begin
             casex(IREQ)
               16'bx1xxxxxxxxxxxxxx : SEL_REQ = 16'b0100000000000000;
               16'b10xxxxxxxxxxxxxx : SEL_REQ = 16'b1000000000000000;
               16'b00xxxxxxxxxxxxx1 : SEL_REQ = 16'b0000000000000001;
               16'b00xxxxxxxxxxxx10 : SEL_REQ = 16'b0000000000000010;
               16'b00xxxxxxxxxxx100 : SEL_REQ = 16'b0000000000000100;
               16'b00xxxxxxxxxx1000 : SEL_REQ = 16'b0000000000001000;
               16'b00xxxxxxxxx10000 : SEL_REQ = 16'b0000000000010000;
               16'b00xxxxxxxx100000 : SEL_REQ = 16'b0000000000100000;
               16'b00xxxxxxx1000000 : SEL_REQ = 16'b0000000001000000;
               16'b00xxxxxx10000000 : SEL_REQ = 16'b0000000010000000;
               16'b00xxxxx100000000 : SEL_REQ = 16'b0000000100000000;
               16'b00xxxx1000000000 : SEL_REQ = 16'b0000001000000000;
               16'b00xxx10000000000 : SEL_REQ = 16'b0000010000000000;
               16'b00xx100000000000 : SEL_REQ = 16'b0000100000000000;
               16'b00x1000000000000 : SEL_REQ = 16'b0001000000000000;
               16'b0010000000000000 : SEL_REQ = 16'b0010000000000000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           16'b1000000000000000 : begin
             casex(IREQ)
               16'b1xxxxxxxxxxxxxxx : SEL_REQ = 16'b1000000000000000;
               16'b0xxxxxxxxxxxxxx1 : SEL_REQ = 16'b0000000000000001;
               16'b0xxxxxxxxxxxxx10 : SEL_REQ = 16'b0000000000000010;
               16'b0xxxxxxxxxxxx100 : SEL_REQ = 16'b0000000000000100;
               16'b0xxxxxxxxxxx1000 : SEL_REQ = 16'b0000000000001000;
               16'b0xxxxxxxxxx10000 : SEL_REQ = 16'b0000000000010000;
               16'b0xxxxxxxxx100000 : SEL_REQ = 16'b0000000000100000;
               16'b0xxxxxxxx1000000 : SEL_REQ = 16'b0000000001000000;
               16'b0xxxxxxx10000000 : SEL_REQ = 16'b0000000010000000;
               16'b0xxxxxx100000000 : SEL_REQ = 16'b0000000100000000;
               16'b0xxxxx1000000000 : SEL_REQ = 16'b0000001000000000;
               16'b0xxxx10000000000 : SEL_REQ = 16'b0000010000000000;
               16'b0xxx100000000000 : SEL_REQ = 16'b0000100000000000;
               16'b0xx1000000000000 : SEL_REQ = 16'b0001000000000000;
               16'b0x10000000000000 : SEL_REQ = 16'b0010000000000000;
               16'b0100000000000000 : SEL_REQ = 16'b0100000000000000;
               default : SEL_REQ = 16'b0;
             endcase
           end
           default : SEL_REQ = 16'b0;
         endcase // casex(PRI)
      end
   endfunction // SEL_REQ


   always@(posedge CLK) begin
      if(RST) begin
         SEL      <= 16'b0;
         STATE    <= 1'b0;
         PRIORITY <= 16'b0000000000000001;
      end
      else begin
         if(~STATE) begin
            if(|REQ) begin
               STATE <= 1'b1;
            end
            SEL <= SEL_REQ(PRIORITY, REQ);
         end
         else begin
            if(PURGE) begin
               if(~|REQ) begin
                  SEL   <= 16'b0;
                  STATE <= 1'b0;
               end
               else begin
                  SEL <= SEL_REQ(PRIORITY, REQ);
               end
               PRIORITY <= {PRIORITY[14:0], PRIORITY[15]};
            end
         end // else: !if(~STATE)
      end // else: !if(RST)
   end // always@ (posedge CLK)

endmodule // arbitor16
