/**
 * SBML-SSAlib bridge: a bridge library to connect SSAlib and SBML
 *
 * Copyright (C) 2004-2009, SBML-SSA Team, Keio/Seikei University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *                    
 * @file    SSALibUtil.h
 * @brief   Utiliti class using SSALib API
 * @author  Keio/Seikei SBML-SSA Team.
 */

#ifndef SSALibUtil_h
#define SSALibUtil_h

#include "common.h"
#include <sbml/SBMLTypes.h>
#include <ostream>

class SSALibUtil
{
public:
  /**
   * print Problem
   */   
  static void printProblem(ostream&, const SSAProblem *);

  /**
   * print Reaction
   */   
  static void printReaction(ostream&, const SSAReaction *);

  /**
   * print InitialCondition
   */   
  static void printInitialCondition(ostream&, const InitialCondition *);

  /**
   * print Term
   */   
  static void printTerm(ostream&, const Term *);

  /**
   * print Trajectory
   */   
  static void printTrajectory(ostream&, const SSATrajectory *);

};

#endif  /* SSALibUtil_h */
