/**
 * SBML-SSAlib bridge: a bridge library to connect SSAlib and SBML
 *
 * Copyright (C) 2004-2009, SBML-SSA Team, Keio/Seikei University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *                    
 * @file    SBMLSSASolver.h
 * @brief   SBML-SSA Bridge
 * @author  Keio/Seikei SBML-SSA Team.
 */

#ifndef SBMLSSASolver_h
#define SBMLSSASolver_h

#include "common.h"
#include <sbml/SBMLTypes.h>

// forward declaration
class SBMLDtoSSAPConverter;
class SSAPtoSBMLDConverter;
class SSASolverLauncher;

class SBMLSSASolver
{
public:
  /**
   * Constructor
   */   
  SBMLSSASolver();
   
  /**
   * Copy Constructor (not implemented yet)
   */   
  // SBMLSSASolver(const SBMLSSASolver&);

  /**
   * Destructor
   */
  virtual ~SBMLSSASolver();

  /**
   * loadSBML by file
   */   
  Problem* loadSBML(const string &filename);

  /**
   * saveSBML
   */   
  bool saveSBML(const string &filename, int level, int version);

  /**
   * runSimulation
   */   
  SSATrajectory* runSimulation(SSASolverType_t solverType, SSATimeLine *timeLine);

  /**
   * getNumSolver
   */   
  int getNumSolvers() const;

  /**
   * getProblem 
   */   
  Problem* getProblem();

  /**
   * getParticipant
   */   
  Participant* getParticipant(const string &participantName);

  /**
   * getNumParticipants
   */   
  int getNumParticipants();

  /**
   * getListOfParticipant
   */   
  vector<Participant*> getListOfParticipant();

  /**
   * loadProblem by Problem (for debugging purpose)
   */   
  Problem* loadProblem(Problem *problem);

protected:

  bool validateSBML(SBMLDocument *sbmlDocument);

  /**
   * Data members
   */

  // An SSA Problem converted from the given SBML
  SSAProblem* mProblem;              

  // SBML -> SSA Problem converter
  SBMLDtoSSAPConverter* mSBMLDtoSSAPConverter; 

  // SSA Problem -> SBML converter
  SSAPtoSBMLDConverter* mSSAPtoSBMLDConverter; 
};

#endif  /* SBMLSSASolver_h */
