/**
 * SBML-SSAlib bridge: a bridge library to connect SSAlib and SBML
 *
 * Copyright (C) 2004-2009, SBML-SSA Team, Keio/Seikei University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *                    
 * @file    SBMLDtoSSAPConverter.h
 * @brief   SBML Document -> SSA Problem converter
 * @author  Keio/Seikei SBML-SSA Team.
 */

#ifndef SBMLDtoSSAPConverter_h
#define SBMLDtoSSAPConverter_h

#include "common.h"
#include <sbml/SBMLTypes.h>

class SBMLDtoSSAPConverter
{
public:

  /**
   * Constructor
   */   
  SBMLDtoSSAPConverter();
   
  /**
   * Copy Constructor (not implemented yet)
   */   
  // SBMLDtoSSAPConverter(const SBMLDtoSSAPConverter&);

  /**
   * Destructor
   */
  virtual ~SBMLDtoSSAPConverter();

  /**
   * convert
   *
   * (NOTE) NULL will be returned if the conversion failed.
   *
   */
  virtual SSAProblem* convert(SBMLDocument *sbmlDocument);

  /**
   * normalizeSBMLDocument 
   *
   * normalize the given SBMLDocument for SSA problem
   * (e.g. unit conversion, kineticlaw conversion and etc...)
   */
  virtual SBMLDocument *normalizeSBMLDocument(SBMLDocument *sbmlDocument);

  /**
   * printErrors
   */
  virtual void printErrors();
};

#endif  /* SBMLDtoSSAPConverter_h */
