#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
//#include "libssa.h"
#include "SBMLSSASolver.h"
#include "SSALibUtil.h"

int main() {
  double alphaFwd[2]={ 5.4,5.4 };
  double alphaBwd[2]={ 40,9.3 };
  double betaFwd[2]= { 140,140 };
  double betaBwd[2]= { 2500,800 };
  double gammaFwd[2]={ 44,44 };
  double gammaBwd[2]={ 33,2.7 };
  double deltaFwd[2]={ 76,76 };
  double deltaBwd[2]={ 300,33 };
  double zetaFwd=50;
  double zetaBwd=1000;
  double epsilonFwd[3][3]={ { 0.0038,0.022,0.12 },
                            { 0.059,3.4,1.9 },
                            { 0.92,5.2,37 } };
  double epsilonBwd[3][3]={ { 5.5,3.1,1.7 },
                            { 6.1,3.4,1.9 },
                            { 6.8,3.8,1.7 } };
  double etaFwd[3][3]={ { 0,0.06,0.12 }, 
                        { 0.032,0.094,0.154 },
                        { 0.064,0.124,0.96 } };

  Participant* Ca;
  Ca=participant("Ca");
  Participant* CaMKII;
  CaMKII=participant("CaMKII");
  Participant* CaM[3][3];
  for(int i=0;i<3;i++) for(int j=0;j<3;j++)
    CaM[i][j]=participant("CaM%d%d",i,j);
  Participant* K[3][3];
  for(int i=0;i<3;i++) for(int j=0;j<3;j++) K[i][j]=participant("K%d%d",i,j);
  Participant* pK[3][3];
  for(int i=0;i<3;i++) for(int j=0;j<3;j++) pK[i][j]=participant("pK%d%d",i,j);
  Participant* D[3][3][3][3]; memset(D,0,sizeof(D));
  for(int i=0;i<3;i++) for(int j=0;j<3;j++)
    for(int k=0;k<3;k++) for(int l=0;l<3;l++)
      if(i<k || (i==k && j<l))          // K01+K10-> and K10+K01-> are same eqn
        D[i][j][k][l]=participant("D%d%d%d%d",i,j,k,l);
  Participant* pD[3][3][3][3];
  for(int i=0;i<3;i++) for(int j=0;j<3;j++)
    for(int k=0;k<3;k++) for(int l=0;l<3;l++)
      pD[i][j][k][l]=participant("pD%d%d%d%d",i,j,k,l);

  ReactionList* rs=reactionList();

  // To drive a species, we modify any reactions where it's a reactant to
  // conserve it (it's a product in equal number too).  That is, the product
  // stoichiometry is always forced to equal the reactant stoichiometry for
  // the driven species, even if the reactant stoichiometry is zero.  Then
  // the reactions conserve the species and we can set it to whatever value
  // we like.

  // Calcium Binding
  for(int i=0;i<2;i++) for(int j=0;j<3;j++) {
    reactionListAdd(rs,   // Ca+CaMij -> CaM(i+1)j
      reaction(alphaFwd[i], termList(term(1,Ca),term(1,CaM[i][j]),0),
                            termList(term(1,CaM[i+1][j]),
                                     term(1,Ca),  // Ca is driven
                                     0)));
    reactionListAdd(rs,   // CaM(i+1)j -> Ca+CaMij
      reaction(alphaBwd[i], termList(term(1,CaM[i+1][j]),0),
                            termList(/*term(1,Ca),*/term(1,CaM[i][j]),0)));
    reactionListAdd(rs,   // Ca+Kij -> K(i+1)j
      reaction(gammaFwd[i], termList(term(1,Ca),term(1,K[i][j]),0),
                            termList(term(1,K[i+1][j]),
                                     term(1,Ca),
                                     0)));
    reactionListAdd(rs,   // K(i+1)j -> Ca+Kij
      reaction(gammaBwd[i], termList(term(1,K[i+1][j]),0),
                            termList(/*term(1,Ca),*/term(1,K[i][j]),0)));
  }
  for(int i=0;i<3;i++) for(int j=0;j<2;j++) {
    reactionListAdd(rs,   // Ca+CaMij -> CaMi(j+1)
      reaction(betaFwd[j], termList(term(1,Ca),term(1,CaM[i][j]),0),
                           termList(term(1,CaM[i][j+1]),
                                    term(1,Ca),
                                    0)));
    reactionListAdd(rs,   // CaMi(j+1) -> Ca+CaMij
      reaction(betaBwd[j], termList(term(1,CaM[i][j+1]),0),
                           termList(/*term(1,Ca),*/term(1,CaM[i][j]),0)));
    reactionListAdd(rs,   // Ca+Kij -> Ki(j+1)
      reaction(deltaFwd[j], termList(term(1,Ca),term(1,K[i][j]),0),
                            termList(term(1,K[i][j+1]),
                                     term(1,Ca),
                                     0)));
    reactionListAdd(rs,   // Ki(j+1) -> Ca+Kij
      reaction(deltaBwd[j], termList(term(1,K[i][j+1]),0),
                            termList(/*term(1,Ca),*/term(1,K[i][j]),0)));
  }

  // Association
  for(int i=0;i<3;i++) for(int j=0;j<3;j++) {
    reactionListAdd(rs,   // CaMKII+CaMij -> Kij
      reaction(epsilonFwd[i][j], termList(term(1,CaMKII),term(1,CaM[i][j]),0),
                                 termList(term(1,K[i][j]),0)));
    reactionListAdd(rs,   // Kij -> CaMKII+CaMij
      reaction(epsilonBwd[i][j], termList(term(1,K[i][j]),0),
                                 termList(term(1,CaMKII),term(1,CaM[i][j]),0)));
  }
  for(int i=0;i<3;i++) for(int j=0;j<3;j++)
    for(int k=0;k<3;k++) for(int l=0;l<3;l++)
      if(i<k || (i==k && j<l)) {        // K01+K10-> and K10+K01-> are same eqn
        reactionListAdd(rs,    // Kij+Kkl -> Dijkl
          reaction(zetaFwd, termList(term(1,K[i][j]),term(1,K[k][l]),0),
                            termList(term(1,D[i][j][k][l]),0)));
        reactionListAdd(rs,    // Dijkl -> Kij+Kkl
          reaction(zetaBwd, termList(term(1,D[i][j][k][l]),0),
                            termList(term(1,K[i][j]),term(1,K[k][l]),0)));
      }
  for(int i=0;i<3;i++) for(int j=0;j<3;j++)
    for(int k=0;k<3;k++) for(int l=0;l<3;l++) {
      reactionListAdd(rs,    // pKij+Kkl -> pDijkl
        reaction(zetaFwd, termList(term(1,pK[i][j]),term(1,K[k][l]),0),
                          termList(term(1,pD[i][j][k][l]),0)));
      reactionListAdd(rs,    // pDijkl -> pKij+Kkl
        reaction(zetaBwd, termList(term(1,pD[i][j][k][l]),0),
                          termList(term(1,pK[i][j]),term(1,K[k][l]),0)));
    }

  // Phosphorylation
  for(int i=0;i<3;i++) for(int j=0;j<3;j++)
    for(int k=0;k<3;k++) for(int l=0;l<3;l++)
      if(i<k || (i==k && j<l)) {
        reactionListAdd(rs,    // Dijkl -> pKij + Kkl
          reaction(etaFwd[i][j], termList(term(1,D[i][j][k][l]),0),
                                 termList(term(1,pK[i][j]),term(1,K[k][l]),0)));
        reactionListAdd(rs,    // Dijkl -> pKij + Kkl
          reaction(etaFwd[k][l], termList(term(1,D[i][j][k][l]),0),
                                 termList(term(1,K[i][j]),term(1,pK[k][l]),0)));
      }
  for(int i=0;i<3;i++) for(int j=0;j<3;j++)
    for(int k=0;k<3;k++) for(int l=0;l<3;l++)
      reactionListAdd(rs,    // pDijkl -> pKij + pKkl
        reaction(etaFwd[k][l], termList(term(1,pD[i][j][k][l]),0),
                               termList(term(1,pK[i][j]),term(1,pK[k][l]),0)));


  InitialCondition ic[]={ { CaMKII,297 }, { CaM[0][0],297*30/80 } };
  InitialCondition* icl[]={ &ic[0],&ic[1],NULL };
  Problem p={ rs->list,icl };

#if 0
  Timeline t={ 0,0,10,0.1 };
  Trajectory* trajectory=DirectLinear(&p,&t);
  Participant* ps[]={ CaMKII,CaM[0][0],K[0][0],NULL };
  trajectoryPlot(trajectory,ps);
  Participant* ps2[]={ Ca,CaM[0][0],CaM[1][0],CaM[0][1],NULL };
  trajectoryPlot(trajectory,ps2);
#endif

  FILE* o=fopen("gp.d","wc");

  // Equilibrate for 2 seconds (finds the K00 equilibrium)
  Timeline t={ 0,0,2,0.01 };

SSALibUtil::printProblem(cout, &p);

/// debugging ----->
	SBMLSSASolver solver;
	solver.loadProblem(&p);
	Trajectory* tr = solver.runSimulation(LIBSSA_DirectLinear, &t);
/// ----> debugging

/*
  Trajectory* tr=DirectLinear(&p,&t);
	*/

  trajectoryWritePts(o,tr);

  // Do a Ca spike train
  double onPeriod=0.05;
  double offPeriod=0.45;
  int nspikes=5;
  for(int i=0;i<nspikes;i++) {

    // Turn the Ca on
    p.initialConditions=trajectoryLastAsIC(tr);
    t.t0=t.start=t.end;
    t.end+=onPeriod;
    for(InitialCondition** ic=p.initialConditions;*ic;ic++)
      if((*ic)->participant==Ca) (*ic)->population=297*20/80;
    tr=DirectLinear(&p,&t);
    trajectoryWritePts(o,tr);

    // Turn the Ca off
    p.initialConditions=trajectoryLastAsIC(tr);
    t.t0=t.start=t.end;
    t.end+=offPeriod;
    for(InitialCondition** ic=p.initialConditions;*ic;ic++)
      if((*ic)->participant==Ca) (*ic)->population=0;
    tr=DirectLinear(&p,&t);
    trajectoryWritePts(o,tr);

  }

  // And let it run for a while absorbing the spike information
  p.initialConditions=trajectoryLastAsIC(tr);
  t.t0=t.start=t.end;
  t.end+=5;
  tr=DirectLinear(&p,&t);
  trajectoryWritePts(o,tr);

  fclose(o);

  unlink("gp.r");
//  Participant* ps[]={ Ca,CaMKII,CaM[0][0],K[0][0],NULL };
  Participant* ps[]={ Ca,K[2][0],K[2][2],pK[2][2],NULL };
  trajectoryWriteGnuplotScript(tr,ps,1.5,7,"time","population");

//  system("gp.r ; gv gp.ps &");
//  system("gs -dNOPAUSE -dBATCH -q -r200 -sDEVICE=pnm -sOutputFile=- gp.ps | pnmrotate -90 | pnmcut -left 2 -top 2 -bottom -2 -right -2 | pnmcrop -white | pnmscale 0.25 | pnmtopng > gp.png");

  system("./gp.r");
  unlink("gp.d");
  unlink("gp.r");
}
