/**
 * SBML-SSAlib bridge: a bridge library to connect SSAlib and SBML
 *
 * Copyright (C) 2004-2009, SBML-SSA Team, Keio/Seikei University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *                    
 * @file    ASTNodeCalculator.h
 * @brief   Calculating ASTNode
 * @author  Keio/Seikei SBML-SSA Team.
 */

#ifndef ASTNodeCalculator_h
#define ASTNodeCalculator_h

#include "common.h"
#include <sbml/SBMLTypes.h>
#include <deque>
#include <stdexcept>

using namespace std;


class ASTNodeCalculator
{
public:
  typedef deque<double> Stack;

  double evalMath(const ASTNode *math, const Model *model);
  double evalMathOfMassAction(const KineticLaw *kl, const Model *model);

private:
  void   _evalMath(const ASTNode *math, const Model *model, const KineticLaw *kl);
  void   _evalMathOfMassAction(const Model *model, const KineticLaw *kl);
  double _getValueById(const string &name, const Model *model);
  double _getValueById(const string &name, const KineticLaw *kl, const Model *model);

  Stack mStack;
};

#endif  /* ASTNodeCalculator_h */
