#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "SBMLSSASolver.h"
#include "SSALibUtil.h"

int main(int argc, char** argv) {

  if (argc < 2)
  {
    cerr << "Input an SBML file name." << endl;
    return 1;
  }

  FILE* o=fopen("gp.d","wc");

  // Equilibrate for 2 seconds (finds the K00 equilibrium)
  Timeline t={ 0,0,2,0.01 };


  // SBMLSSASolver Main block  -------------------->

  SBMLSSASolver solver;
  //solver.loadProblem(&p);
  solver.loadSBML(argv[1]);
  Trajectory* tr = solver.runSimulation(LIBSSA_DirectLinear, &t);
  Problem *p     = solver.getProblem();

  // debugging
  SSALibUtil::printProblem(cout, p);

  // -------------------> SBMLSSASolver Main block 


/*
  Trajectory* tr=DirectLinear(&p,&t);
	*/

  trajectoryWritePts(o,tr);

  // Do a Ca spike train
  double onPeriod=0.05;
  double offPeriod=0.45;
  int nspikes=5;
  for(int i=0;i<nspikes;i++) {

    // Turn the Ca on
    p->initialConditions=trajectoryLastAsIC(tr);
    t.t0=t.start=t.end;
    t.end+=onPeriod;
    for(InitialCondition** ic=p->initialConditions; *ic ;ic++)
       if(strcmp((*ic)->participant->name,"Ca")==0) (*ic)->population=297*20/80;
    tr=DirectLinear(p,&t);
    trajectoryWritePts(o,tr);

    // Turn the Ca off
    p->initialConditions=trajectoryLastAsIC(tr);
    t.t0=t.start=t.end;
    t.end+=offPeriod;
    for(InitialCondition** ic=p->initialConditions;*ic;ic++)
       if(strcmp((*ic)->participant->name,"Ca") == 0) (*ic)->population=0;
    tr=DirectLinear(p,&t);
    trajectoryWritePts(o,tr);

  }

  // And let it run for a while absorbing the spike information
  p->initialConditions=trajectoryLastAsIC(tr);
  t.t0=t.start=t.end;
  t.end+=5;
  tr=DirectLinear(p,&t);
  trajectoryWritePts(o,tr);

  fclose(o);

//  unlink("gp.r");
//  Participant* ps[]={ Ca,CaMKII,CaM[0][0],K[0][0],NULL };
//  Participant* ps[]={ Ca,K[2][0],K[2][2],pK[2][2],NULL };
  Participant* ps[]={ solver.getParticipant("Ca"), 
                      solver.getParticipant("K_20"),
                      solver.getParticipant("K_22"),
                      solver.getParticipant("pK_22"),
                      NULL };
  trajectoryWriteGnuplotScript(tr,ps,1.5,7,"time","population");

//  system("gp.r ; gv gp.ps &");
//  system("gs -dNOPAUSE -dBATCH -q -r200 -sDEVICE=pnm -sOutputFile=- gp.ps | pnmrotate -90 | pnmcut -left 2 -top 2 -bottom -2 -right -2 | pnmcrop -white | pnmscale 0.25 | pnmtopng > gp.png");

  system("./gp.r");
//  unlink("gp.d");
//  unlink("gp.r");
}
