`include "mydefinition.h"

`timescale 1ns/1ps

module lcdTop_test;

   reg clk, rst_;

   wire lcdEnable;
   wire lcdRegisterSelect;
   wire lcdReadWrite;
   wire [`LCDDATA] dataBitHigh;
   wire [`LCDDATA] dataBitLow;

   parameter 	   STEP = 10;

   initial begin
      $shm_open();
      $shm_probe("AC");
   end
   
   always #(STEP/2) clk = ~clk;

   initial begin
      clk = 1;
      rst_ = 1;
      #(STEP/4);
      #(STEP*50);
      rst_ = 0;
      #(STEP*50);
      rst_ = 1;
      #(STEP* 2_000_000);
      $finish;
   end
   
   lcdTop LT( .clk( clk),
	      .rst_( rst_),
	      .lcdEnable( lcdEnable),
	      .lcdRegisterSelect( lcdRegisterSelect),
	      .lcdReadWrite( lcdReadWrite),
	      .dataBitHigh( dataBitHigh),
	      .dataBitLow( dataBitLow));
endmodule // lcdTop_test
