`include "mydefinition.h"

`timescale 1ns/1ps
module lcdBuffer_test;
   reg clk, rst_;
   reg [`LCDCOMMAND] command;
   reg 		     commandEnable;
   reg 		     busy;

   wire [`LCDCOMMAND] bufferOut;
   wire 	      bufferEnable;

   parameter 	      STEP = 10;
   integer 	      i;
   
   initial begin
      $shm_open();
      $shm_probe("AC");
   end

   always #(STEP/2) clk = ~clk;
   
   initial begin
      clk = 1;
      rst_ = 1;
      command = `LCD_COMMAND_ZERO;
      commandEnable = 0;
      busy = 1;
      #(STEP/4);
      #(STEP *50);
      rst_ = 0;
      #(STEP * 50);
      rst_ = 1;
      for ( i = 0; i < 10; i = i + 1) begin
	 #(STEP);
	 command = i;
      end
      #(STEP);
      for ( i = 0; i < 10; i = i + 1) begin
	 #(STEP);
	 command = i;
	 commandEnable = 1;
      end
      #(STEP);
      commandEnable = 0;
      #(STEP*10);
      busy = 0;
      #(STEP * 50);
      busy = 1;
      #(STEP *20);
      $finish;
   end

   lcdBuffer LB( .clk( clk),
		 .rst_( rst_),
		 .command( command),
		 .commandEnable( commandEnable),
		 .busy( busy),

		 .bufferOut( bufferOut),
		 .bufferEnable( bufferEnable));
   
endmodule // lcdBuffer_test
