`include "mydefinition.h"

module lcdSecond( clk, rst_, initSignal, initPulse, pulseCounter, 
		  secondSignal, secondPulse);

   input clk, rst_;
   input initSignal;
   input initPulse;
   input [`LCDPULSE] pulseCounter;

   output 	     secondSignal;
   output 	     secondPulse;
   reg 		     secondSignal;
   reg 		     secondPulse;
   
   reg [`LCDSECONDCOUNTER] secondCounter;

   wire 		   encourageSecondPulse;
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
         secondCounter <= `LCD_SECOND_COUNTER_ZERO;
      end else begin
         if ( (initSignal & pulseCounter==`LCD_PULSE_MAX) &
              (~initPulse & secondCounter < `LCD_SECOND_COUNTER_OK)) begin
            secondCounter <= secondCounter + `LCD_SECOND_COUNTER_ONE;
	 end else begin
	    secondCounter <= secondCounter;
	 end
      end
   end 
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 secondSignal <= `LOW;
      end else begin
	 if ( secondCounter < `LCD_SECOND_COUNTER_OK) begin
	    secondSignal <= secondSignal;
	 end else begin
	    secondSignal <= `HIGH;
	 end
      end
   end

   assign encourageSecondPulse = ( secondCounter == `LCD_SECOND_COUNTER_OK &
				   ~secondSignal) ? `HIGH : `LOW;

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 secondPulse <= `LOW;
      end else begin
	 secondPulse <= encourageSecondPulse;
      end
   end
   
endmodule // lcdSecond
