`include "mydefinition.h"

module lcdInit( clk, rst_, initSignal, initPulse);

   input clk, rst_;
   output initSignal;
   output initPulse;
   reg 	  initSignal;
   reg     initPulse;
   
   reg [`LCDINITCOUNTER] initCounter;

   wire 		 encourageInitPulse;
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 initCounter <= `LCD_INIT_COUNTER_ZERO;
	 initSignal <= `LOW;
      end else begin
	 if ( initCounter < `LCD_INIT_COUNTER_OK) begin
	    initCounter <= initCounter + `LCD_INIT_COUNTER_ONE;
	    initSignal <= `LOW;
	 end else begin
	    initCounter <= initCounter;
	    initSignal <= `HIGH;
	 end
      end
   end 

   assign encourageInitPulse = ( initCounter == `LCD_INIT_COUNTER_OK &
				 initSignal == `LOW) ? `HIGH : `LOW;
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
         initPulse <= `LOW;
      end else begin
	 initPulse <= encourageInitPulse;
      end
   end
endmodule

