`include "mydefinition.h"

module lcdFourth( clk, rst_, thirdSignal, thirdPulse, pulseCounter,
		  fourthSignal, fourthPulse);

   input clk, rst_;
   input thirdSignal;
   input thirdPulse;
   input [`LCDPULSE] pulseCounter;

   output 	     fourthSignal;
   output 	     fourthPulse;
   reg 		     fourthSignal;
   reg 		     fourthPulse;

   reg [`LCDFOURTHCOUNTER] fourthCounter;

   wire 		  encourageFourthPulse;
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 fourthCounter <= `LOW;
      end else begin
	 if ( ( thirdSignal & ( pulseCounter == `LCD_PULSE_MAX)) &
	      ( ~thirdPulse & fourthCounter < `LCD_FOURTH_COUNTER_OK)) begin
	    fourthCounter <= fourthCounter + `LCD_FOURTH_COUNTER_ONE;
	 end else begin
	    fourthCounter <= fourthCounter;
	 end
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 fourthSignal <= `LOW;
      end else begin
	 if ( fourthCounter < `LCD_FOURTH_COUNTER_OK) begin
	    fourthSignal <= fourthSignal;
	 end else begin
	    fourthSignal <= `HIGH;
	 end
      end
   end

   assign encourageFourthPulse = ( fourthCounter == `LCD_FOURTH_COUNTER_OK &
				  ~fourthSignal) ? `HIGH : `LOW;
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 fourthPulse <= `LOW;
      end else begin
	 fourthPulse <= encourageFourthPulse;
      end
   end

endmodule // lcdFourth
