`include "mydefinition.h"

module lcdUser( clk, rst_,
		command, commandEnable);

   input clk, rst_;
   output [`LCDCOMMAND] command;
   output 		commandEnable;

   reg [`LCDCOMMAND] 	command;
   reg 			commandEnable;

   reg [`LCDSTATE] 	lcdState;

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 lcdState <= `LCD_ST_ZERO;
      end else begin
	 if ( lcdState == `LCD_ST_FIFTEEN) begin
	    lcdState <= lcdState;
	 end else begin
	    lcdState <= lcdState + `LCD_ST_ONE;
	 end
      end
   end
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 command <= `LCD_COMMAND_ZERO;
      end else begin
	 case ( lcdState)
	   `LCD_ST_ZERO:
	     command <= `LCD_COMMAND_FUNCTION_SET;

	   `LCD_ST_ONE:
	     command <= 10'b00_0000_0110;

	   `LCD_ST_TWO:
	     command <= 10'b00_0000_1100;

	   `LCD_ST_THREE:
	     command <= `LCD_COMMAND_CLEAR_DISPLAY;

	   `LCD_ST_FOUR:
	     command <= 10'b00_1000_0010; // set DD RAM addres 0x02

	   `LCD_ST_FIVE:
	     command <= 10'b10_1100_1010; // write "ha"

	   `LCD_ST_SIX:
	     command <= 10'b10_1101_1011; // write "ro"

	   `LCD_ST_SEVEN:
	     command <= 10'b10_1010_1011; // write "xo"
	   
	   `LCD_ST_EIGHT:
	     command <= 10'b10_1111_1110; // write " "

	   `LCD_ST_NINE:
	     command <= 10'b10_1101_1100; // write "wa"

	   `LCD_ST_TEN:
	     command <= 10'b10_0010_1101; // write "-"

	   `LCD_ST_ELEVEN:
	     command <= 10'b10_1101_1001; // write "ru"

	   `LCD_ST_TWELVE:
	     command <= 10'b10_1100_0100; // write "to"

	   `LCD_ST_THIRTEEN:
	     command <= 10'b10_1101_1110; // write " '' "

	   `LCD_ST_FOURTEEN:
	     command <= 10'b10_0010_0001; // write "!"
	   	   
	   default:
	     command <= `LCD_COMMAND_ZERO;
	 endcase
	 
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 commandEnable <= `LOW;
      end else begin
	 if ( lcdState == `LCD_ST_FIFTEEN) begin
	    commandEnable <= `LOW;
	 end else begin
	    commandEnable <= `HIGH;
	 end
      end
   end
   
endmodule // lcdUser
