`include "mydefinition.h"

module lcdDecoder( clk, rst_, command, commandEnable,
		   storingCommandEnable, data, dataEnable);
   
   input clk, rst_;
   input [`LCDCOMMAND] command;
   input 	       commandEnable;

   output 	       storingCommandEnable;
   output [`LCDDATA_RSRW] data;
   output 		  dataEnable;

   reg [`LCDDATA_RSRW] 	  data;
   reg 			  dataEnable;
   
   reg [`LCDTRANSFERCOUNTER] lcdTransferCounter;
   reg [`LCDTRANSFERSTATUS]  lcdTransferStatus;

   reg [`LCDCOMMAND] 	     storingCommand;
   reg 			     storingCommandEnable;

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 storingCommandEnable <= `LOW;
      end else begin
	 if ( storingCommandEnable) begin
	    if ( lcdTransferStatus == `LCD_TRANSFER_STATUS_ZERO) begin
	       storingCommandEnable <= `LOW;
	    end else begin
	       storingCommandEnable <= storingCommandEnable;
	    end
	 end else begin
	    storingCommandEnable <= commandEnable;
	 end
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 storingCommand <= `LCD_COMMAND_ZERO;
      end else begin
	 if ( storingCommandEnable) begin
	    storingCommand <= storingCommand;
	 end else begin
	    storingCommand <= command;
	 end
      end
   end
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 lcdTransferStatus <= `LCD_TRANSFER_STATUS_ZERO;
      end else begin
	 case ( lcdTransferStatus)
	   `LCD_TRANSFER_STATUS_ZERO: begin
	      if ( commandEnable) begin
		 lcdTransferStatus <= `LCD_TRANSFER_STATUS_ONE;
	      end else begin
		 lcdTransferStatus <= lcdTransferStatus;
	      end
	   end

	   `LCD_TRANSFER_STATUS_ONE: begin
	      if ( storingCommand[9:8]==2'b01) begin
		 lcdTransferStatus <= `LCD_TRANSFER_STATUS_TWO;
	      end else begin
		 lcdTransferStatus <= `LCD_TRANSFER_STATUS_THREE;
	      end
	   end

	   `LCD_TRANSFER_STATUS_TWO: begin
	      if ( lcdTransferCounter == `LCD_TRANSFER_COUNTER_1US) begin
		 lcdTransferStatus <= `LCD_TRANSFER_STATUS_ZERO;
	      end else begin
		 lcdTransferStatus <= lcdTransferStatus;
	      end
	   end

	   `LCD_TRANSFER_STATUS_THREE: begin
	      if ( lcdTransferCounter == `LCD_TRANSFER_COUNTER_1US) begin
		 lcdTransferStatus <= `LCD_TRANSFER_STATUS_FOUR;
	      end else begin
		 lcdTransferStatus <= lcdTransferStatus;
	      end
	   end

	   `LCD_TRANSFER_STATUS_FOUR: begin
	      lcdTransferStatus <= `LCD_TRANSFER_STATUS_FIVE;
	   end

	   `LCD_TRANSFER_STATUS_FIVE: begin
	      if ( (storingCommand == `LCD_COMMAND_CLEAR_DISPLAY |
		    storingCommand == `LCD_COMMAND_RETURN_CURSOR_HOME)) begin
		 if ( lcdTransferCounter == `LCD_TRANSFER_COUNTER_1_64MS)begin
		    lcdTransferStatus <= `LCD_TRANSFER_STATUS_ZERO;
		 end else begin
		    lcdTransferStatus <= lcdTransferStatus;
		 end
	      end else if (lcdTransferCounter==`LCD_TRANSFER_COUNTER_40US)begin
		 lcdTransferStatus <= `LCD_TRANSFER_STATUS_ZERO;
	      end else begin
		 lcdTransferStatus <= lcdTransferStatus;
	      end
	   end

	   default: begin
	      lcdTransferStatus <= lcdTransferStatus;
	   end
	 endcase
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 lcdTransferCounter <= `LCD_TRANSFER_COUNTER_ZERO;
      end else begin
	 if ( lcdTransferStatus == `LCD_TRANSFER_STATUS_TWO   |
	      lcdTransferStatus == `LCD_TRANSFER_STATUS_THREE |
	      lcdTransferStatus == `LCD_TRANSFER_STATUS_FIVE) begin
	    lcdTransferCounter <= lcdTransferCounter+`LCD_TRANSFER_COUNTER_ONE;
	 end else begin
	    lcdTransferCounter <= `LCD_TRANSFER_COUNTER_ZERO;
	 end
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 data <= `LCD_DATA_ZERO;
      end else begin
	 if ( lcdTransferStatus == `LCD_TRANSFER_STATUS_ONE) begin
	    data <= { storingCommand[9:8], storingCommand[7:4]};
	 end else if ( lcdTransferStatus == `LCD_TRANSFER_STATUS_FOUR) begin
	    data <= { storingCommand[9:8], storingCommand[3:0]};
	 end else begin
	    data <= `LCD_DATA_RSRW_ZERO;
	 end
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 dataEnable <= `LOW;
      end else begin
	 if ( lcdTransferStatus == `LCD_TRANSFER_STATUS_ONE | 
	       lcdTransferStatus == `LCD_TRANSFER_STATUS_FOUR ) begin
	    dataEnable <= `HIGH;
	 end else begin
	    dataEnable <= `LOW;
	 end
      end
   end
		   
endmodule // lcdDecoder
