`include "mydefinition.h"

module lcd_test;
   reg clk, rst_;
   reg [`LCDCOMMAND] command;
   reg 		     commandEnable;
   
   wire lcdEnable;
   wire lcdRegisterSelect;
   wire lcdReadWrite;
   wire [`LCDDATA] dataBitHigh;
   wire [`LCDDATA] dataBitLow;
   wire 	   busy;

   reg [`LCDDATA]  dataBitHighReg;

   assign 	   dataBitHigh=dataBitHighReg;
   
   parameter 	   STEP=10;

   initial begin
      $shm_open();
      $shm_probe("AC");
   end

   always #(STEP/2) clk = ~clk;

   initial begin
      clk = 1;
      rst_ = 1;
      command = 0;
      commandEnable = 0;
      dataBitHighReg= 4'bzzzz;
      #(STEP*50);
      rst_ = 0;
      #(STEP*50);
      rst_ = 1;
      #(STEP*1_015_000);
      $finish;
   end
   
   lcd LCD( .clk( clk),
	    .rst_( rst_),
	    .lcdEnable( lcdEnable),
	    .lcdRegisterSelect( lcdRegisterSelect),
	    .lcdReadWrite( lcdReadWrite),
	    .command( command),
	    .commandEnable( commandEnable),
	    .busy( busy),
	    .dataBitHigh( dataBitHigh), 
	    .dataBitLow( dataBitLow)
	    );
endmodule // lcd_test
