`include "mydefinition.h"

module lcdPulseCounter( clk, rst_, 
			firstPulse, secondPulse,
			thirdPulse, fourthPulse,
			decodeDataEnable,
			
			pulseCounter);
   input clk, rst_;
   input firstPulse, secondPulse;
   input thirdPulse, fourthPulse;
   input decodeDataEnable;
   
   output [`LCDPULSE] pulseCounter;
   reg [`LCDPULSE]    pulseCounter;

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 pulseCounter <= `LCD_PULSE_ZERO;
      end else begin
	 if ( ( firstPulse | secondPulse) |
	      ( thirdPulse| fourthPulse) | 
	      decodeDataEnable ) begin
	    pulseCounter <= `LCD_PULSE_ZERO;
	 end else if ( pulseCounter < `LCD_PULSE_MAX) begin
	    pulseCounter <= pulseCounter + `LCD_PULSE_ONE;
	 end else begin
	    pulseCounter <= pulseCounter;
	 end
      end
   end
endmodule // lcdPulseCounter
