`include "mydefinition.h"

module lcdBuffer( clk, rst_, command, commandEnable,busy,
		  bufferOut, bufferEnable
		  );

   input clk, rst_;
   input [`LCDCOMMAND] command;
   input 	       commandEnable;
   input 	       busy;

   output [`LCDCOMMAND] bufferOut;
   output 		bufferEnable;

   reg [`LCDCOMMAND] 	bufferOut;
   reg 			bufferEnable;
 
   reg [`LCDBUFFERCOUNTER] lcdBufferCounter;
   
   wire 	lfReadEnable;
   wire 	lfWriteEnable;
   wire 	lfEmpty;
   wire 	lfFull;
   wire [`LCDCOMMAND] lfOut;
   wire 	      lfValid;
   
   assign 	lfWriteEnable = ( rst_ & commandEnable & ~lfFull)? 
				  `HIGH : `LOW;
   
   function AssignReadEnable;
      input rst_;
      input busy;
      input lfEmpty;
      input [`LCDBUFFERCOUNTER] lcdBufferCounter;
      
      if ( (rst_ & ~busy) &
	   (~lfEmpty & lcdBufferCounter == `LCD_BUFFER_COUNTER_MAX)) begin
	 AssignReadEnable = `HIGH;
      end else begin
	 AssignReadEnable = `LOW;
      end
   endfunction // AssignReadEnable
   
   assign 	lfReadEnable = AssignReadEnable( rst_, busy, 
						 lfEmpty, lcdBufferCounter);
   
   lcdFifo LF( .clk( clk),
	       .rd_en( lfReadEnable),
	       .wr_en( lfWriteEnable),
	       .full( lfFull),
          .rst( ~rst_),
	       .empty( lfEmpty),
	       .dout( lfOut),
	       .din( command),
	       .valid( lfValid));

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 lcdBufferCounter <= `LCD_BUFFER_COUNTER_ZERO;
      end else begin
	 if ( lfReadEnable == `HIGH) begin
	    lcdBufferCounter <= `LCD_BUFFER_COUNTER_ZERO;
	 end else if ( lcdBufferCounter == `LCD_BUFFER_COUNTER_MAX) begin
	    lcdBufferCounter <= lcdBufferCounter;
	 end else begin
	    lcdBufferCounter <= lcdBufferCounter + `LCD_BUFFER_COUNTER_ONE;
	 end
      end
   end
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 bufferOut <= `LCD_COMMAND_ZERO;
      end else begin
	 bufferOut <= lfOut;
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 bufferEnable <= `LOW;
      end else begin
	 bufferEnable <= lfValid;
      end
   end
   
endmodule // lcdBuffer
