`include "mydefinition.h"
`include "chatter.h"

`timescale 1ns/1ps

module beep_test;
   reg clk, rst_;
   reg southSwitch;

   wire beep;
   wire beepLED;

   parameter STEP = 2;

   always #(STEP/2) clk = ~clk;
   
   /*initial begin
      $dumpfile("waves.dump");
      $dumpvars(0, BEEP);
   end*/

   initial begin
      $shm_open();
      $shm_probe("AC");
   end
   
   initial begin
      clk = 1;
      rst_ = 1;
      southSwitch = 0;
      #(STEP / 4);
      #(STEP * 100);
      rst_ = 0;
      #(STEP * 100);
      rst_ = 1;
      #(STEP * 10);
      southSwitch = 1;
      #(STEP * 50);
      southSwitch = 0;
      #(STEP * 20);
      southSwitch = 1;
      #(STEP * 50);
      southSwitch = 0;
      #(STEP * 20);
      southSwitch = 1;
      #(STEP * 10_000_000);
      southSwitch = 0;
      #(STEP *20);
      $finish;
   end
   
      
   beep BEEP( .clk( clk),
	      .rst_( rst_),
	      .southSwitch( southSwitch),
	      .beep( beep),
	      .beepLED( beepLED));
   
endmodule // beep_test
