`include "mydefinition.h"
`include "chatter.h"

module beep(clk, rst_, southSwitch, beep, beepLED);
   input clk, rst_;
   input southSwitch;
   
   output beep;
   output beepLED;
   
   reg 	  beep;
   reg    beepLED;

   reg [`BEEPCOUNTER]  beepCounter;
   reg [`BEEPSWITCH]   switchOn;

   reg [`BEEPDOREMI]   beepDoremi;
   reg [`BEEPONESECOND] beepOneSecond;

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 beepOneSecond <= `BOSZERO;
      end else begin
	 if ( switchOn[1]) begin
	    if ( beepOneSecond == `BOSMAX) begin
	       beepOneSecond <= `BOSZERO;
	    end else begin
	       beepOneSecond <= beepOneSecond + `BOSONE;
	    end
	 end else begin
	    beepOneSecond <= `BOSZERO;
	 end
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 beepDoremi <= `BEEP_LOWDO;
      end else begin
	 if ( switchOn[1]) begin
	    if ( beepOneSecond == `BOSMAX) begin
	       if ( beepDoremi == `BEEP_HIGHDO) begin
		  beepDoremi <= `BEEP_LOWDO;
	       end else begin
		  beepDoremi <= beepDoremi + `BEEP_DOREMI_ONE;
	       end
	    end else begin
	       beepDoremi <= beepDoremi;
	    end
	 end else begin
	    beepDoremi <= `BEEP_LOWDO;
	 end
      end
   end
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 beepCounter <= `BCZERO;
      end else begin
	 if ( switchOn[1]) begin
	    case ( beepDoremi)
	      3'd0: begin
		 if ( beepCounter == `BCMAX_LOWDO) begin
		    beepCounter <= `BCZERO;
		 end else begin
		    beepCounter <= beepCounter + `BCONE;
		 end
	      end

	      3'd1: begin
		 if ( beepCounter == `BCMAX_RE) begin
		    beepCounter <= `BCZERO;
		 end else begin
		    beepCounter <= beepCounter + `BCONE;
		 end
	      end

	      3'd2: begin
		 if ( beepCounter == `BCMAX_MI) begin
		    beepCounter <= `BCZERO;
		 end else begin
		    beepCounter <= beepCounter + `BCONE;
		 end
	      end

	      3'd3: begin
		 if ( beepCounter == `BCMAX_FA) begin
		    beepCounter <= `BCZERO;
		 end else begin
		    beepCounter <= beepCounter + `BCONE;
		 end
	      end

	      3'd4: begin
		 if ( beepCounter == `BCMAX_SO) begin
		    beepCounter <= `BCZERO;
		 end else begin
		    beepCounter <= beepCounter + `BCONE;
		 end
	      end

	      3'd5: begin
		 if ( beepCounter == `BCMAX_RA) begin
		    beepCounter <= `BCZERO;
		 end else begin
		    beepCounter <= beepCounter + `BCONE;
		 end
	      end

	      3'd6: begin
		 if ( beepCounter == `BCMAX_SI) begin
		    beepCounter <= `BCZERO;
		 end else begin
		    beepCounter <= beepCounter + `BCONE;
		 end
	      end

	      3'd7: begin
		 if ( beepCounter == `BCMAX_HIGHDO) begin
		    beepCounter <= `BCZERO;
		 end else begin
		    beepCounter <= beepCounter + `BCONE;
		 end
	      end
	    endcase
	 end else begin
	    beepCounter <= `BCZERO;
	 end
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 beep <= `LOW;
      end else begin
         if (switchOn[1]) begin
	    case ( beepDoremi)
	      `BEEP_LOWDO: begin
		 if ( beepCounter == `BCMAX_LOWDO) begin
		    beep <= ~beep;
		 end else begin
		    beep <= beep;
		 end
	      end

	      `BEEP_RE: begin
		 if ( beepCounter == `BCMAX_RE) begin
		    beep <= ~beep;
		 end else begin
		    beep <= beep;
		 end
	      end

	      `BEEP_MI: begin
		 if ( beepCounter == `BCMAX_MI) begin
		    beep <= ~beep;
		 end else begin
		    beep <= beep;
		 end
	      end

	      `BEEP_FA: begin
	 	 if ( beepCounter == `BCMAX_FA) begin
		    beep <= ~beep;
		 end else begin
		    beep <= beep;
		 end
	      end

	      `BEEP_SO: begin
		 if ( beepCounter == `BCMAX_SO) begin
		    beep <= ~beep;
		 end else begin
		    beep <= beep;
		 end
	      end

	      `BEEP_RA: begin
		 if ( beepCounter == `BCMAX_RA) begin
		    beep <= ~beep;
		 end else begin
		    beep <= beep;
		 end
	      end

	      `BEEP_SI: begin
		 if ( beepCounter == `BCMAX_SI) begin
		    beep <= ~beep;
		 end else begin
		    beep <= beep;
		 end
	      end

	      default: begin
		 if ( beepCounter == `BCMAX_HIGHDO) begin
		    beep <= ~beep;
		 end else begin
		    beep <= beep;
		 end
	      end
	    endcase
	 end else begin
	    beep <= beep;
	 end
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 beepLED <= `LOW;
      end else begin
	 if ( switchOn[1]) begin
	    beepLED <= ~beepLED;
	 end else begin
	    beepLED <= beepLED;
	 end
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 switchOn <= `BEEP_SWITCH_ZERO;
      end else begin
	 case ( switchOn[0])
	   `LOW: begin
	      if ( southSwitch) begin
		 switchOn[1] <= ~switchOn[1];
		 switchOn[0] <= ~switchOn[0];
	      end else begin
		 switchOn <= switchOn;
	      end
	   end

	   default: begin
	      if ( ~southSwitch) begin
		 switchOn[1] <= switchOn[1];
		 switchOn[0] <= ~switchOn[0];
	      end else begin
		 switchOn <= switchOn;
	      end
	   end
	 endcase
      end
   end
   
endmodule