`include "mydefinition.h"

`timescale 1ns/1ps

module lcdInit_test;

   reg clk, rst_;
   wire initSignal;
   wire initPulse;

   parameter STEP = 10;

   initial begin
     $shm_open();
     $shm_probe("AC");
   end 

   always #(STEP/2) clk = ~clk;

   initial begin
      clk = 1;
      rst_ = 1;
      #(STEP/4);
      #(STEP * 100);
      rst_ = 0;
      #(STEP * 50);
      rst_ = 1;
      #(STEP * 1_000_000);
      rst_ = 0;
      #(STEP * 50);
      rst_ = 1;
      #(STEP * 1_000_000);
      $finish;
   end

   lcdInit lcdInit( .clk( clk),
   .rst_( rst_),
   .initSignal( initSignal),
   .initPulse( initPulse));

endmodule

