#!/usr/local64/perl/bin/perl -w

##$B%H%C%W%b%8%e!<%kL>$H$=$NB>$N%b%8%e!<%k72$r5-=R(B##
$top_module_name = "top";
@modules=(
          "beep.v",
          "clockMaker.v",
	  "led.v",
	  "lcd.v",
	  "lcdBuffer.v",
	  "lcdDecoder.v",
	  "lcdFifo.v",
	  "lcdInitializer.v",
	  "lcdPulseCounter.v",
	  "lcdTop.v",
	  "lcdUser.v",
	  "myClock2.v",
	  "top.v"
	  );
##$B$3$3$G$O(BCoreGenerator$B$N%U%!%$%k$b(B.v$B$G%*%C%1!<(B##
##$B$?$@$7!":#8e$N%W%m%;%9$N$?$a$K(B
##.ngc$B$^$?$O(B .edn$B%U%!%$%k$rMQ0U$9$k$3$H(B


if(@ARGV == 1){

    @delte_extension = qw(.lso .ngc .ngr .prj .syr .xst _vhdl.prj .ngd);

    if($ARGV[0] eq 'clean'){
        foreach(@delte_extension){
            $tmp = $top_module_name."$_";
            if(-e $tmp){
                print "delete file $tmp \n";
                unlink($tmp);
            }
        }
        $tmp = "xst";
        system("rm -rf $tmp");
        print "delete directory $tmp \n";
    }
    exit(1);
}


##$B$3$3$+$iJT=83+;O(B##
$top_file_name = "$top_module_name";
$device_name = "xc5vlx110t-1-ff1136";
$ise_version = "10.1";
$ise_path = "/home/cad/xilinx/ISE-$ise_version/ISE";
$xst_path = "$ise_path/bin/lin64/xst";
##$B$3$3$^$GJT=8(B##

print $ise_path."\n";
print $xst_path."\n";

system("mkdir -p xst/projnav.tmp");
#dump.xst, projnav.tmp work

$prj="";
for($i=0;$i<@modules;$i++){
    $prj.="verilog work \"".$modules[$i]."\"\n";
}
print $prj;

$lso="work"."\n";
$xst = &xst($top_file_name, $top_module_name, $device_name);

$prjfile = "$top_file_name.prj";
$xstfile = "$top_file_name.xst";
$lsofile = "$top_file_name.lso";

open(FP,">$prjfile");
print FP $prj;
close(FP);

open(FP,">$xstfile");
print FP $xst;
close(FP);

open(FP,">$lsofile");
print FP $lso;
close(FP);


system("env LD_LIBRARY_PATH=$ise_path/bin/lin $xst_path -ifn $top_file_name.xst -ofn $top_file_name.syr");


$flag = 0;
open(FP,"<$top_file_name.syr");
while($line=<FP>){
    if($line =~ /Device utilization summary:/){
        print "=========================================================================\n";
        $flag = 1;
    }
    elsif($line =~ /Timing Summary:/){
        $flag = 1;
    }
    elsif($line =~ /Timing Detail:/
          || $line =~ /TIMING REPORT/){
        $flag = 0;
    }

    print $line if($flag == 1);
}
print "=========================================================================\n";
close(FP);


## $B%*%W%7%g%s$N0UL#$K$D$$$F$O(B
## xilinx$B$N(Bweb$B;2>H(B
## $B13$G$9!"$J$/$7$F$7$^$C$?$N$GC/$+(Bwiki$B$KDI2C$7$F$/$@$5$k$H=u$+$j$^$9!D(B
sub xst{
my $xst="";
my $top_file_name = $_[0];
my $top_module_name = $_[1];
my $device_name = $_[2];

$xst.= <<EOF;
set -tmpdir "./xst/projnav.tmp"
set -xsthdpdir "./xst"
run
-ifn $top_file_name.prj
-ifmt mixed
-ofn $top_file_name
-ofmt NGC
-p $device_name
-top $top_module_name
-opt_mode Speed
-opt_level 2
-lso $top_file_name.lso
-verilog2001 YES
-vlgcase full
-case maintain
-fsm_extract yes
-fsm_style lut
-fsm_encoding auto
-ram_extract yes
-ram_style auto
-rom_extract yes
-rom_style auto
-mult_style auto
-mux_style auto
-decoder_extract yes
-priority_extract yes
-safe_implementation yes
-shreg_extract yes
-shift_extract yes
-xor_collapse yes
-resource_sharing yes
-use_dsp48 auto
-auto_bram_packing yes
-bram_utilization_ratio 100
-dsp_utilization_ratio 100
-max_fanout 10000
-move_first_stage yes
-move_last_stage yes
-bufg 32
-reduce_control_sets auto
-keep_hierarchy NO
-register_balancing yes
-iobuf YES
-slice_packing yes
-use_carry_chain yes
-use_clock_enable auto
-use_sync_set auto
-use_sync_reset auto
-cross_clock_analysis yes
-write_timing_constraints yes
-glob_opt allclocknets
-equivalent_register_removal yes
-netlist_hierarchy as_optimized
EOF

return $xst;
}
