`include "mydefinition.h"

module lcdFifth( clk, rst_, fourthSignal, fourthPulse, pulseCounter,
		  fifthSignal);

   input clk, rst_;
   input fourthSignal;
   input fourthPulse;
   input [`LCDPULSE] pulseCounter;

   output 	     fifthSignal;
   reg 		     fifthSignal;

   reg [`LCDFIFTHCOUNTER] fifthCounter;

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 fifthCounter <= `LOW;
      end else begin
	 if ( ( fourthSignal & ( pulseCounter == `LCD_PULSE_MAX)) &
	      ( ~fourthPulse & fifthCounter < `LCD_FIFTH_COUNTER_OK)) begin
	    fifthCounter <= fifthCounter + `LCD_FIFTH_COUNTER_ONE;
	 end else begin
	    fifthCounter <= fifthCounter;
	 end
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 fifthSignal <= `LOW;
      end else begin
	 if ( fifthCounter < `LCD_FIFTH_COUNTER_OK) begin
	    fifthSignal <= fifthSignal;
	 end else begin
	    fifthSignal <= `HIGH;
	 end
      end
   end

endmodule // lcdFifth
