`include "mydefinition.h"

module lcdThird( clk, rst_, secondSignal, secondPulse, pulseCounter,
		 thirdSignal, thirdPulse);

   input clk, rst_;
   input secondSignal;
   input secondPulse;
   input [`LCDPULSE] pulseCounter;

   output 	     thirdSignal;
   output 	     thirdPulse;
   reg 		     thirdSignal;
   reg 		     thirdPulse;

   reg [`LCDTHIRDCOUNTER] thirdCounter;

   wire 		  encourageThirdPulse;
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 thirdCounter <= `LOW;
      end else begin
	 if ( ( secondSignal & ( pulseCounter == `LCD_PULSE_MAX)) &
	      ( ~secondPulse & thirdCounter < `LCD_THIRD_COUNTER_OK)) begin
	    thirdCounter <= thirdCounter + `LCD_THIRD_COUNTER_ONE;
	 end else begin
	    thirdCounter <= thirdCounter;
	 end
      end
   end

   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 thirdSignal <= `LOW;
      end else begin
	 if ( thirdCounter < `LCD_THIRD_COUNTER_OK) begin
	    thirdSignal <= thirdSignal;
	 end else begin
	    thirdSignal <= `HIGH;
	 end
      end
   end

   assign encourageThirdPulse = ( thirdCounter == `LCD_THIRD_COUNTER_OK &
				  ~thirdSignal) ? `HIGH : `LOW;
   
   always @ ( posedge clk or negedge rst_) begin
      if ( rst_ == `ENABLE_) begin
	 thirdPulse <= `LOW;
      end else begin
	 thirdPulse <= encourageThirdPulse;
      end
   end

endmodule // lcdThird
