/* test bench */
`timescale 1ns/1ps
`include "def.h"
module test;
parameter STEP = 10;
   reg clk, rst_n;
   reg [`DATA_W-1:0] datain;
   reg [`SEL_W-1:0] com;
   reg [`ADDR_W-1:0] addr;
   reg we;
   wire [`DATA_W-1:0] accout;
   reg [`DATA_W-1:0] dmem [`DEPTH-1:0];
   always @(posedge clk) 
   begin 
      if(we) dmem[addr] <= accout;
   end

   always #(STEP/2) begin
            clk <= ~clk;
   end
   datapath datapath_1(.clk(clk), .rst_n(rst_n), .com(com),
               .datain(dmem[addr]), .accout(accout));
   initial begin
      $dumpfile("datapath.vcd");
      $dumpvars(0,test);
      $readmemh("dmem.dat", dmem);
      clk <= `DISABLE;
      rst_n <= `ENABLE_N;
      {we,com,addr} <= {`DISABLE,`ALU_THB,`ADDR_W'h00}; // LD 0
   #(STEP*1/4)
   #STEP
      rst_n <= `DISABLE_N;
      $display("we:%b com:%h addr:%h accout:%h", we, com, addr, accout);
     $display("dmem[0]:%h dmem[1]:%h dmem[2]:%h", dmem[0], dmem[1], dmem[2]);
   #(STEP*1/2)
      {we,com,addr} <= {`DISABLE,`ALU_ADD,`ADDR_W'h01};  // ADD 1
   #(STEP*1/2)
      $display("we:%b com:%h addr:%h accout:%h", we, com, addr, accout);
     $display("dmem[0]:%h dmem[1]:%h dmem[2]:%h", dmem[0], dmem[1], dmem[2]);
   #(STEP*1/2)
      {we,com,addr} <= {`DISABLE,`ALU_ADD,`ADDR_W'h02};   // ADD 2
   #(STEP*1/2)
      $display("we:%b com:%h addr:%h accout:%h", we, com, addr, accout);
     $display("dmem[0]:%h dmem[1]:%h dmem[2]:%h", dmem[0], dmem[1], dmem[2]);
   #(STEP*1/2)
      {we,com,addr} <= {`ENABLE,`ALU_THA,`ADDR_W'h02};   // ST 2
   #(STEP*1/2)
      $display("we:%b com:%h addr:%h accout:%h", we, com, addr, accout);
     $display("dmem[0]:%h dmem[1]:%h dmem[2]:%h", dmem[0], dmem[1], dmem[2]);
   #(STEP*1/2)
      {we,com,addr} <= {`DISABLE,`ALU_THA,`ADDR_W'h02};  // NOP
   #(STEP*1/2)
      $display("we:%b com:%h addr:%h accout:%h", we, com, addr, accout);
     $display("dmem[0]:%h dmem[1]:%h dmem[2]:%h", dmem[0], dmem[1], dmem[2]);
     $finish;
   end
endmodule
