`define DATA_W 16  // bit width
`define SEL_W 3 //control width
`define ALU_THA `SEL_W'b000  
`define ALU_THB `SEL_W'b001  
`define ALU_AND `SEL_W'b010  

module alu (
  input [`DATA_W-1:0] a, b,
  input [`SEL_W-1:0] s,
  output [`DATA_W:0] y );

function [`DATA_W-1:0] alu;
  input [`DATA_W-1:0] in1, in2;
  input [`SEL_W-1:0] sel;
  begin
    case (sel)
     `ALU_THA: alu= in1;
     `ALU_THB: alu= in2;
     `ALU_AND: alu= in1 & in2;
     default: alu= in1 + in2 ;
   endcase
  end
endfunction

assign y = alu(a,b,s);
endmodule
