`define DLY 3'b011
module mmem (
	input [9:0] addr,
	input [15:0] datain,
	output [15:0] dataout,
	output rdy,
	input req,
	input we, 
	input clk);

reg [15:0] mem[0:1023];
reg [3:0] count;
reg [2:0] mdly;

always @(posedge clk) begin
	if(!req) mdly <= 0;
	else if(mdly != `DLY) mdly <= mdly+1;
end

always @(posedge clk) begin
	if(!rdy) count <= 0;
	else if( count != 4'b1111) count <= count + 1;
end

assign rdy = (mdly == `DLY) ;
assign dataout = rdy ? mem[{addr[9:3],count[2:0]}]:16'b0; 

always @(posedge clk) begin
	if(rdy & we) mem[{addr[9:3],count[2:0]}] <= datain;
end

endmodule
