/* test bench */
`timescale 1ns/1ps
`define DATA_W 16  // bit width
`define SEL_W 3 //control width
`define ALU_THA `SEL_W'b000  
`define ALU_THB `SEL_W'b001  
`define ALU_AND `SEL_W'b010  
`define ALU_ADD `SEL_W'b110  

module test; 
parameter STEP = 10;
   reg [`DATA_W-1:0] ina, inb;
   reg [`SEL_W-1:0] sel;
   wire [`DATA_W-1:0] outs;
   
   alu alu_1(.a(ina), .b(inb), .s(sel), .y(outs));
   initial begin
      $dumpfile("alu.vcd");
      $dumpvars(0,alu_1);
      ina <= `DATA_W'h1111;
      inb <= `DATA_W'h2222;
      sel <= `ALU_THA;
     #STEP
      $display("a:%h b:%h s:%h y:%h", ina, inb, sel, outs);
      sel <= `ALU_THB;
     #STEP
      $display("a:%h b:%h s:%h y:%h", ina, inb, sel, outs);
      sel <= `ALU_AND;
     #STEP
      $display("a:%h b:%h s:%h y:%h", ina, inb, sel, outs);
      sel <= `ALU_ADD;
     #STEP
      $display("a:%h b:%h s:%h y:%h", ina, inb, sel, outs);
     $finish;
   end 
endmodule
