`define DATA_W 16  // bit width
`define SEL_W 3 //control width
`define ALU_THA `SEL_W'b000  
`define ALU_THB `SEL_W'b001  
`define ALU_AND `SEL_W'b010  

module alu (
  input [`DATA_W-1:0] a, b, 
  input [`SEL_W-1:0] s,
  output [`DATA_W-1:0] y );
  assign y = s==`ALU_THA ? a:
             s==`ALU_THB ? b:
             s==`ALU_AND ? a & b: a + b ;
endmodule
