module alu #(parameter DATA_W=16,  
 	SEL_W=3,
        ALU_THA=3'b000, 
        ALU_THB=3'b001, 
        ALU_AND=3'b010 )
 (input [DATA_W-1:0] a, b, 
  input [SEL_W-1:0] s,
  output [DATA_W:0] y );

  assign y = s== ALU_THA ? a:
             s== ALU_THB ? b:
             s== ALU_AND ? a & b: a + b ;
endmodule
