`include "mydefinition.h"

module lcdPulseCounter( clk, rst, 
			firstPulse, secondPulse,
			thirdPulse, fourthPulse,
			decodeDataEnable,
			
			pulseCounter);
   input clk, rst;
   input firstPulse, secondPulse;
   input thirdPulse, fourthPulse;
   input decodeDataEnable;
   
   output [`LCDPULSE] pulseCounter;
   reg [`LCDPULSE]    pulseCounter;

   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 pulseCounter <= `LCD_PULSE_ZERO;
      end else begin
	 if ( ( firstPulse | secondPulse) |
	      ( thirdPulse| fourthPulse) | 
	      decodeDataEnable ) begin
	    pulseCounter <= `LCD_PULSE_ZERO;
	 end else if ( pulseCounter < `LCD_PULSE_MAX) begin
	    pulseCounter <= pulseCounter + `LCD_PULSE_ONE;
	 end else begin
	    pulseCounter <= pulseCounter;
	 end
      end
   end
endmodule // lcdPulseCounter
