module lcdFifo (
  valid, rd_en, wr_en, full, empty, clk, rst, dout, din
);
  output valid;
  input rd_en;
  input wr_en;
  output full;
  output empty;
  input clk;
  input rst;
  output [9 : 0] dout;
  input [9 : 0] din;

reg [9:0] f0,f1,f2,f3;  // f0<-f1<-f2<-f3
reg [1:0] count;

always @(posedge clk or posedge rst) begin
	if(rst) count <= 2'b00;
	if(wr_en & ~rd_en & ~full) count <= count+1;
	else if(~wr_en & rd_en & ~empty) count <= count-1; end

always @ (posedge clk or posedge rst) begin
	if(wr_en & ~full) 
		case(count)
			0: if (~rd_en) f0 <= din;
			1: if (rd_en) f0 <= din; else f1<=din;
			2: if (rd_en) begin
				f0<=f1; f1<= din; end
			   else f2 <= din;
			3: if (rd_en) begin
				f0<=f1; f1<=f2; f2<= din; end
			   else f3 <= din;
		endcase
	else if(rd_en & ~empty) 
		case(count)
			1: f0 <= f1;
			2: begin f0 <= f1; f1<=f2; end
			3: begin f0 <= f1; f1<=f2; f2<=f3; end
		endcase
end
assign empty = (count == 0);
assign full = (count == 3);
assign dout = f0;
assign valid = ~empty;
endmodule
