/* test bench */
`timescale 1ns/1ps
`include "def.h"
module test;
//parameter STEP = 10;
parameter STEP = 20;
   reg clk50, btn_south, btn_north, btn_east, btn_west, btn_rot;
   reg [3:0] sw;
   integer i;
   wire [7:0] led;
   wire [7:0] db;

   always #(STEP/2) begin
            clk50 <= ~clk50;
   end

   always @(posedge clk50) begin
            i <= i +1;
   end

   poco_top_sim pt1(.clk50(clk50), .btn_rot(btn_rot), .btn_north(btn_north), .btn_south(btn_south),
	.btn_east(btn_east), .btn_west(btn_west), .sw(sw), .led(led), 
	.lcd_rs(lcd_rs), .lcd_e(lcd_e), .lcd_rw(lcd_rw), .db(db));

   initial begin
      $dumpfile("poco.vcd");
      $dumpvars(0,test);
      clk50 <= `DISABLE;
      btn_rot <= `ENABLE;
      i <= 0;
      {btn_north, btn_south, btn_east, btn_west, sw} <= 8'b00001010;
   #(STEP*1/4)
   #(STEP*5)
      btn_rot <= `DISABLE;
   #(STEP*50)            
      {btn_north, btn_south, btn_east, btn_west, sw} <= 8'b00000000;
   #(STEP*50)            
      {btn_north, btn_south, btn_east, btn_west, sw} <= 8'b00001010;
   #(STEP*50)            
      {btn_north, btn_south, btn_east, btn_west, sw} <= 8'b00000000;
   $finish;
   end

   always @(negedge pt1.clk50) begin
      $display("--- pc: %h ---", pt1.poco_1.pc);
      $display("idatain:%b", pt1.poco_1.idatain);
      $display("reg:%h %h %h %h %h %h %h %h", 
	pt1.poco_1.rfile_1.r0, pt1.poco_1.rfile_1.r1, pt1.poco_1.rfile_1.r2,
	pt1.poco_1.rfile_1.r3, pt1.poco_1.rfile_1.r4, pt1.poco_1.rfile_1.r5,
	pt1.poco_1.rfile_1.r6, pt1.poco_1.rfile_1.r7);
      $display("dmem[00 ~ 03]: %h %h %h %h", pt1.dmem_1.mem[0], pt1.dmem_1.mem[1], pt1.dmem_1.mem[2], pt1.dmem_1.mem[3]);
      $display("dmem[04 ~ 07]: %h %h %h %h", pt1.dmem_1.mem[4], pt1.dmem_1.mem[5], pt1.dmem_1.mem[6], pt1.dmem_1.mem[7]);
	$display("");
   end

   always @(negedge pt1.clk50) begin
	if(pt1.led_we) $display("### %d LED:%h ###", i,led);
   end

   always @(negedge pt1.clk50) begin
	if(pt1.lcd_we) $display("### %d LCD:%h ###", i,pt1.wd);
   end

endmodule
