/* test bench */
`timescale 1ns/1ps
`include "def.h"
module test_rv32i;
parameter STEP = 10;
   reg clk, rst_n;
   wire [`DATA_W-1:0] ddataout, ddatain, dmemrd ;
   wire [`DATA_W-1:0] iaddr;
   wire [`DATA_W-1:0] daddr;
   wire [`DATA_W-1:0] idata;
   wire [3:0] we;
   wire [7:0] odata;
   wire dispf, disp_en, inp_en, dmem_en, inpf,ecall_op;
   reg set;
   reg [`DATA_W/4-1:0] indata;
   assign disp_en = (daddr[31:4] == 28'hc000000);
   assign inp_en = (daddr[31:4] == 28'hc100000);
   assign dmem_en = (daddr[`DATA_W-1:18]==0);

   always #(STEP/2) begin
            clk <= ~clk;
   end

   rv32i rv32i_1(.clk(clk), .rst_n(rst_n), .instr(idata),
               .readdata(ddatain), .pc(iaddr), .aluresult(daddr),
               .writedata(ddataout), .we(we), .ecall_op(ecall_op) );
   disp disp_1(.clk(clk), .rst_n(rst_n), .data(ddataout[23:16]),
       .we(we[2] & disp_en), .flag(dispf) );
   inmodule inmodule_1(.clk(clk), .rst_n(rst_n), .idata(indata), .odata(odata),
      .we(set), .re(inp_en & daddr[3:0] == 4'b0010), .flag(inpf));

  imem  imem_1(.a(iaddr[17:2]), .rd(idata) );
  dmem  dmem_1(.clk(clk), .a(daddr[17:2]), .rd(dmemrd), 
  					.wd(ddataout), .we({4{dmem}}&we) );
  assign ddatain = disp_en ? {7'b0,dispf,24'b0} : inp_en ? {7'b0,inpf,odata,16'b0} :
                                          dmemrd;


   initial begin
      $dumpfile("rv32i.vcd");
      $dumpvars(0);
      clk <= `DISABLE;
      rst_n <= `ENABLE_N;
	  set <= `DISABLE;
   #(STEP*1/4)
   #STEP
      rst_n <= `DISABLE_N;
   
  #(STEP*10)
  #(STEP*10)
      indata <= 8'h41;
      set <= `ENABLE;
   #STEP
      set <= `DISABLE;
   #(STEP*10)
      indata <= 8'h42;
      set <= `ENABLE;
   #STEP
      set <= `DISABLE;
   #(STEP*10)
      indata <= 8'h43;
      set <= `ENABLE;
   #STEP
      set <= `DISABLE;
   #(STEP*10)
      indata <= 8'h44;
      set <= `ENABLE;
   #STEP
      set <= `DISABLE;
   #(STEP*50)
   $finish;
   end

   always @(negedge clk) begin
      $display("pc:%h idatain:%h", rv32i_1.pc, rv32i_1.instr);
      $display("reg:%h %h %h %h %h %h %h | %h", 
	rv32i_1.rfile_1.rf[1], rv32i_1.rfile_1.rf[2],
	rv32i_1.rfile_1.rf[3], rv32i_1.rfile_1.rf[4], rv32i_1.rfile_1.rf[5],
	rv32i_1.rfile_1.rf[6], rv32i_1.rfile_1.rf[7], rv32i_1.rfile_1.rf[31]);
    $display("dmem:%h %h %h %h", dmem_1.mem[0], dmem_1.mem[1], dmem_1.mem[2], dmem_1.mem[3] );
	if(ecall_op) $finish;
   end 
endmodule
