`include "def.h"
module rv32i(
input clk, rst_n,
input [`DATA_W-1:0] instr,
input [`DATA_W-1:0] readdata,
output reg [`DATA_W-1:0] pc, 
output [`DATA_W-1:0] aluresult,
output [`DATA_W-1:0] writedata,
output [3:0] we,
output ecall_op);

wire addcom;
wire [2:0] funct3;
wire [6:0] funct7;
wire [`REG_W-1:0] rs1, rs2, rd ;
wire [`DATA_W-1:0] reg1, reg2, srca, srcb, result;
wire [`OPCODE_W-1:0] opcode;
wire [`SHAMT_W-1:0] shamt;
wire [`OPCODE_W-1:0] func;
wire [`DATA_W-1:0] pcplus4;
wire [11:0] imm_i, imm_s;
wire [12:0] imm_b;
wire [20:0] imm_j;
wire rwe;
wire alu_op, imm_op, bra_op;
wire sw_op, beq_op, bne_op, blt_op, bge_op, bltu_op, bgeu_op, lw_op, jal_op;
wire lb_op, lbu_op, sb_op ;
wire slt_op;
wire ext;
wire signed [31:0] sreg1, sreg2;
wire [19:0] sext;

assign sreg1 = $signed(reg1);
assign sreg2 = $signed(reg2);
assign {funct7, rs2, rs1, funct3, rd, opcode} = instr;
assign sext = {20{instr[31]}};
assign imm_i = {funct7,rs2};
assign imm_s = {funct7,rd};
assign imm_b = {funct7[6],rd[0],funct7[5:0],rd[4:1],1'b0};
assign imm_j = {instr[31], instr[19:12],instr[20],instr[30:21],1'b0};
// Decorder
assign sb_op = (opcode == `OP_STORE) & (funct3 == 3'b000);
assign sw_op = (opcode == `OP_STORE) & (funct3 == 3'b010);
assign lb_op = (opcode == `OP_LOAD) & (funct3 == 3'b000);
assign lw_op = (opcode == `OP_LOAD) & (funct3 == 3'b010);
assign lbu_op = (opcode == `OP_LOAD) & (funct3 == 3'b100);
assign alu_op = (opcode == `OP_REG) ;
assign imm_op = (opcode == `OP_IMM) ;
assign bra_op = (opcode == `OP_BRA) ;
assign lui_op = (opcode == `OP_LUI);
assign jal_op = (opcode == `OP_JAL);
assign jalr_op = (opcode == `OP_JALR)& (funct3== 3'b000);
assign beq_op = bra_op & (funct3 == 3'b000);
assign bne_op = bra_op & (funct3 == 3'b001);
assign blt_op = bra_op & (funct3 == 3'b100);
assign bge_op = bra_op & (funct3 == 3'b101);
assign bltu_op = bra_op & (funct3 == 3'b110);
assign bgeu_op = bra_op & (funct3 == 3'b111);
assign ecall_op = (opcode == `OP_SPE) & (funct3 == 3'b000);


assign ext = alu_op  & funct7[5];

assign writedata = 
					sb_op & aluresult[1] & aluresult[0] ? {reg2[7:0],24'b0}: 
					sb_op & aluresult[1] & !aluresult[0] ? {8'b0,reg2[7:0],16'b0}:
					sb_op & !aluresult[1] & aluresult[0] ? {16'b0,reg2[7:0],8'b0}:
					sb_op & !aluresult[1] & !aluresult[0] ? {24'b0,reg2[7:0]}: reg2;

assign we = { (sw_op | aluresult[1] & aluresult[0] & sb_op),
			(sw_op | aluresult[1] & !aluresult[0] & sb_op),
			(sw_op | !aluresult[1] & aluresult[0] & sb_op),
			(sw_op | !aluresult[1] & !aluresult[0] & sb_op)};

assign srcb = imm_op | lw_op | lb_op |jalr_op ? {sext, imm_i}: 
				bra_op ? {sext[18:0],imm_b}: 
				sw_op | sb_op ? {sext, imm_s}:
				jal_op ? {sext[10:0], imm_j}:
				reg2;

assign srca = bra_op | jal_op ? pc: reg1;

assign result = (jal_op|jalr_op) ? pcplus4 :
				lui_op ? {instr[31:12],12'b0}:
				lw_op  ? readdata :
				lb_op & aluresult[1] & aluresult[0] ? {{24{readdata[31]}},readdata[31:24]}:
				lb_op & aluresult[1]& !aluresult[0]? {{24{readdata[23]}},readdata[23:16]}:
				lb_op & !aluresult[1]& aluresult[0]? {{24{readdata[15]}},readdata[15:8]}:
		        lb_op & !aluresult[1]& !aluresult[0]? {{24{readdata[7]}},readdata[7:0]}:
								        aluresult;

assign addcom = (lw_op|lb_op|sw_op|sb_op|bra_op|jal_op|jalr_op);

assign rwe = lw_op | lb_op | alu_op | imm_op | jal_op | jalr_op | lui_op  ;

alu alu_1(.a(srca), .b(srcb), .s(funct3), .ext(ext), .addcom(addcom),  .y(aluresult));

rfile rfile_1(.clk(clk), .rd1(reg1), .a1(rs1), .rd2(reg2), .a2(rs2), 
	.wd3(result), .a3(rd), .we3(rwe));

assign pcplus4 = pc+4;
always @(posedge clk or negedge rst_n) 
begin 
   if(!rst_n) pc <= 0;
   else if (jal_op | 
               ( (beq_op & (reg1==reg2)) | (bne_op & (reg1!=reg2)) |
   		(blt_op & (sreg1<sreg2) ) | (bge_op & (sreg1>=sreg2) ) |
   		(bltu_op & (reg1<reg2) ) | (bgeu_op & (reg1>=reg2) ) )  )
     pc <= aluresult;
	else if(jalr_op)
	 pc <= {aluresult[31:1],1'b0};
   else 
     pc <= pcplus4;
end

endmodule
