`define IDLE 4'b0001
`define RPLS 4'b0010
`define CRDY 4'b0100
`define WAIT 4'b1000
`define IDLE_BIT 2'b00
`define RPLS_BIT 2'b01
`define CRDY_BIT 2'b10
`define WAIT_BIT 2'b11

module cache (
	input [9:0] paddr,
	input [31:0] mdata,
	input [31:0] pdata,
	output [9:0] maddr,
	output [31:0] odata,
	output rdy,
	output mem_req,
	output mem_we,
	input mem_rdy,
	input req,
	input we,
	input rst_n,
	input clk);

reg [31:0] cmem[0:63];
reg [5:0] tagm[0:7];
reg [3:0] stat;
reg [2:0] count;
wire [5:0] caddr;
wire hit; 
wire [3:0] tag;
wire [2:0] index;

assign index = paddr[5:3];
assign tag = paddr[9:6];
assign caddr = stat[`RPLS_BIT]  ? {index,count} : paddr[5:0];
assign maddr = stat[`WAIT_BIT] ? paddr :
		stat[`RPLS_BIT] ? {tag,index,count} : 10'b0;
assign mem_req = req & (stat[`RPLS_BIT] | stat[`WAIT_BIT]|
		 stat[`IDLE_BIT] & !hit | stat[`IDLE_BIT] & we ); 
assign mem_we = we;
assign rdy = req & (stat[`IDLE_BIT] & hit & ~we | stat[`CRDY_BIT] | 
				stat[`WAIT_BIT] & mem_rdy);

assign hit = tagm[index][0] & tagm[index][5:2] == paddr[9:6] ;
assign odata = stat[`WAIT_BIT] ? pdata: cmem[caddr];

always @(posedge clk or negedge rst_n) begin
	if(!rst_n) stat <= `IDLE;
	else 
	case (stat) 
	`IDLE: if(req) begin
		if(we) stat <= `WAIT; 
		else if(!hit) begin
			stat <= `RPLS;
			count <= 0;  end
	       end
	`RPLS: if(mem_rdy) begin
		count <= count+1;
		if(count == 3'b111) 
			stat <= `CRDY;
	       end
	`WAIT: if(mem_rdy) stat <= `IDLE;
	`CRDY: stat <=`IDLE;
	endcase
end
		
always @(posedge clk)  begin
	if(stat[`IDLE_BIT] & hit & we) cmem[caddr] <= pdata;
	else if(stat[`RPLS_BIT] & mem_rdy) cmem[caddr] <= mdata;
end

always @(posedge clk) begin
	if(stat[`RPLS_BIT] & count == 3'b111) 
		tagm[index] <= {paddr[9:6],2'b01};
end

endmodule
