`define IDLE 3'b001
`define RPLS 3'b010
`define CRDY 3'b100
`define IDLE_BIT 2'b00
`define RPLS_BIT 2'b01
`define CRDY_BIT 2'b10

module cache (
	input [9:0] addr,
	input [31:0] mdata,
	output [31:0] odata,
	output rdy,
	output mem_req,
	input mem_rdy,
	input req,
	input rst_n,
	input clk);

reg [31:0] cmem[0:63];
reg [5:0] tag[0:7];
reg [2:0] stat;
reg [2:0] count;
wire [5:0] caddr;
wire hit;

assign caddr = stat[`RPLS_BIT] ? {addr[5:3],count} : addr[5:0];
assign mem_req = req & (stat[`RPLS_BIT] | stat[`IDLE_BIT] & !hit ); 
assign rdy = req & (stat[`IDLE_BIT] & hit | stat[`CRDY_BIT]);

assign hit = tag[addr[5:3]][0] & tag[addr[5:3]][5:2] == addr[9:6] ;
assign odata = cmem[caddr];

always @(posedge clk or negedge rst_n) begin
	if(!rst_n) stat <= `IDLE;
	else 
	case (stat) 
	`IDLE: if(req & !hit) begin
		stat <= `RPLS;
		count <= 0; 
	       end
	`RPLS: if(mem_rdy) begin
		count <= count+1;
		if(count == 3'b111) 
			stat <= `CRDY;
	       end
	`CRDY: stat <=`IDLE;
	endcase
end
		
always @(posedge clk) 
	if(stat[`RPLS_BIT] & mem_rdy) cmem[caddr] <= mdata;

always @(posedge clk) 
	if(stat[`RPLS_BIT] & count == 3'b111) 
		tag[addr[5:3]] <= {addr[9:6],2'b01};

endmodule
