`include "def.h"
`define FETCH    5'b0_0001
`define DECODE   5'b0_0010
`define MEMADR   5'b0_0100
`define MEM    5'b0_1000
`define EXE    5'b1_0000

`define FETCH_B    3'b000
`define DECODE_B   3'b001
`define MEMADR_B   3'b010
`define MEM_B  	3'b011
`define EXE_B 	3'b100

module rv32i(
input clk, rst_n,
input [`DATA_W-1:0] readdata,
output [`DATA_W-1:0] adr, 
output [`DATA_W-1:0] writedata,
output we,
output ecall_op);

reg [4:0] stat;
wire addcom;
wire [2:0] funct3;
wire [6:0] funct7;
wire [`REG_W-1:0] rs1, rs2, rd ;
reg [`DATA_W-1:0] reg1, reg2, regalu, ir, pc;
wire [`DATA_W-1:0] srca, srcb, bra_srcb,result, a, b, aluresult;
wire [`OPCODE_W-1:0] opcode;
wire [11:0] imm_i, imm_s;
wire [12:0] imm_b;
wire [20:0] imm_j;
wire rwe;
wire alu_op, imm_op, bra_op;
wire sw_op, beq_op, bne_op, blt_op, bge_op, bltu_op, bgeu_op, lw_op, jal_op;
wire slt_op;
wire ext;
wire signed [31:0] sreg1, sreg2;
wire [19:0] sext;
wire exec;

assign writedata = reg2;

assign sreg1 = $signed(reg1);
assign sreg2 = $signed(reg2);
assign {funct7, rs2, rs1, funct3, rd, opcode} = ir;
assign sext = {20{ir[31]}};
assign imm_i = {funct7,rs2};
assign imm_s = {funct7,rd};
assign imm_b = {funct7[6],rd[0],funct7[5:0],rd[4:1],1'b0};
assign imm_j = {ir[31], ir[19:12],ir[20],ir[30:21],1'b0};
// Decorder
assign sw_op = (opcode == `OP_STORE) & (funct3 == 3'b010);
assign lw_op = (opcode == `OP_LOAD) & (funct3 == 3'b010);
assign alu_op = (opcode == `OP_REG) ;
assign imm_op = (opcode == `OP_IMM) ;
assign bra_op = (opcode == `OP_BRA) ;
assign jal_op = (opcode == `OP_JAL);
assign jalr_op = (opcode == `OP_JALR)& (funct3== 3'b000);
assign beq_op = bra_op & (funct3 == 3'b000);
assign bne_op = bra_op & (funct3 == 3'b001);
assign blt_op = bra_op & (funct3 == 3'b100);
assign bge_op = bra_op & (funct3 == 3'b101);
assign bltu_op = bra_op & (funct3 == 3'b110);
assign bgeu_op = bra_op & (funct3 == 3'b111);
assign ecall_op = (opcode == `OP_SPE) & (funct3 == 3'b000);

assign ext = stat[`EXE_B] & alu_op  & funct7[5];
assign we = stat[`MEM_B] & sw_op;
assign adr = stat[`FETCH_B] ? pc: regalu;

assign bra_srcb = 
   (beq_op & reg1==reg2 | bne_op & reg1!=reg2) ?  {sext[18:0],imm_b}: 4;

assign srcb = stat[`DECODE_B] ? 4 :
				imm_op | lw_op |jalr_op ? {sext, imm_i}: 
				bra_op ? bra_srcb:
				sw_op ? {sext, imm_s}:
				jal_op ? {sext[10:0], imm_j}:
				reg2;

assign srca = stat[`DECODE_B] ? pc:
	 stat[`EXE_B] & (bra_op | jal_op  ) ? pc: reg1;

assign result = stat[`MEM_B] & lw_op ? readdata : aluresult ;

assign addcom = (stat[`FETCH_B] | stat[`DECODE_B] | stat[`MEMADR_B] & (lw_op|sw_op) |
				stat[`EXE_B] & (bra_op|jal_op|jalr_op) );

assign rwe = stat[`DECODE_B] & (jal_op|jalr_op) | 
				stat[`MEM_B] & lw_op | 
				stat[`EXE_B] & (alu_op | imm_op)  ;

alu alu_1(.a(srca), .b(srcb), .s(funct3), .ext(ext), .addcom(addcom),  .y(aluresult));

rfile rfile_1(.clk(clk), .rd1(a), .a1(rs1), .rd2(b), .a2(rs2), 
	.wd3(result), .a3(rd), .we3(rwe));

always @(posedge clk or negedge rst_n) 
begin 
   if(!rst_n) ir <= 0;
   else if(stat[`FETCH_B] ) ir <= readdata;
end

always @(posedge clk or negedge rst_n) 
begin 
   if(!rst_n) pc <= 0;
   else if(stat[`DECODE_B] & !(bra_op|jal_op|jalr_op) | stat[`EXE_B] & (bra_op | jal_op ))
     pc <= aluresult;
	else if(stat[`EXE_B] & jalr_op)
	 pc <= {aluresult[31:1],1'b0};
end

always @(posedge clk or negedge rst_n) 
   if(!rst_n) begin reg1 <= 0; reg2 <= 0; end
   else if(stat[`DECODE_B]) begin reg1<= a; reg2<=b; end

always @(posedge clk or negedge rst_n) 
   if(!rst_n) regalu <= 0; 
   else regalu <= aluresult;

always @(posedge clk or negedge rst_n) 
begin 
   if(!rst_n) stat <= `FETCH;
   else
         case (stat)
	       `FETCH: stat <= `DECODE;
	       `DECODE: if(lw_op | sw_op) stat <= `MEMADR;
		   			else stat <= `EXE;
		   `MEMADR: stat <= `MEM;
		   `MEM: stat <= `FETCH;
		   `EXE: stat <= `FETCH;
		endcase
end

endmodule
