module mmem (
	input [9:0] addr,
	input [31:0] datain,
	output [31:0] dataout,
	output reg rdy,
	input req,
	input we, block,
	input clk, rst_n);

reg [31:0] mem[0:1023];
reg [2:0] count;

always @(posedge clk or negedge rst_n) begin
	if(!rst_n) rdy <= 0;
	else rdy <= req;
end

always @(posedge clk or negedge rst_n) begin
	if(!rst_n) count <= 0;
	else if(!req) count <= 0;
	else if( rdy & block & count != 3'b111) count <= count + 1;
end

assign dataout = rdy ? mem[{addr[9:3],count}]:16'b0; 

always @(posedge clk) begin
	if(block & rdy & we) mem[{addr[9:3],count}] <= datain;
	else if(~block & rdy & we) mem[addr] <= datain;
end

endmodule
