#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

unsigned long XWGetColorByName(Display *disp, char *name)
{
	Colormap cmap;
	XColor c0, c1;
	cmap = DefaultColormap(disp, 0);
	XAllocNamedColor(disp, cmap, name, &c1, &c0);
	return(c1.pixel);
}

unsigned long *XWGetGrayscaleCells(Display *disp, int max)
{
	XColor color;
	Colormap cmap;
	unsigned long *pixels, plane_mask[1];
	int i;

	cmap = DefaultColormap(disp, 0);
	pixels = malloc(sizeof(unsigned long)*max);

	color.flags = DoRed | DoGreen | DoBlue;
	XAllocColorCells(disp, cmap, False, plane_mask, 0, pixels, max);
	for(i = 0; i < max; i++){
		color.pixel = pixels[i];
		color.red  =  65536/max*i;
		color.green  = 65536/max*i;
		color.blue  = 65536/max*i;
		XStoreColor(disp, cmap, &color);
	}
	return pixels;
}

void XWDefineWMSettings(Display *disp, Window win,
	int basewidth, int baseheight, int minwidth, int minheight,
	int maxwidth, int maxheight, Bool iconflag, char *iconbmfile,
	char *iconbmmaskfile, Bool iconify)
{
	XSizeHints sizehint;
	XWMHints wmh;
	Pixmap bmap, bmapmask;
	int xh, yh;
	unsigned int width, height;

	sizehint.flags = (USPosition | USSize | PBaseSize |PMinSize | PMaxSize);
	if(basewidth != 0){
		sizehint.base_width = basewidth;
	}
	if(baseheight != 0){
		sizehint.base_height = baseheight;
	}
	if(minwidth != 0){
		sizehint.min_width = minwidth;
	}
	if(minheight != 0){
		sizehint.min_height = minheight;
	}
	if(maxwidth != 0){
		sizehint.max_width = maxwidth;
	}
	if(maxheight != 0){
		sizehint.max_height = maxheight;
	}
	XSetWMNormalHints(disp, win, &sizehint);

	if(True == iconflag){
		XReadBitmapFile(disp, win, iconbmfile, &width, &height, &bmap,
			&xh, &yh);
		wmh.flags = IconPixmapHint | StateHint;
		wmh.icon_pixmap = bmap;
		if(iconbmmaskfile != NULL){
			XReadBitmapFile(disp, win, iconbmmaskfile, &width, &height,
				&bmapmask, &xh, &yh);
			wmh.icon_mask = bmapmask;
		}
	}
	if(True == iconify){
		wmh.initial_state = IconicState;
	}else{
		wmh.initial_state = NormalState;
	}
	XSetWMHints(disp, win, &wmh);
}

XWDefineWMIconSetting(Display *disp, Window win, int iconify, char *iconbmfile,
	char *iconbmmaskfile)
{
	XSizeHints sizehint;
	XWMHints wmh;
	Pixmap bmap, bmapmask;
	int xh, yh;
	unsigned int width, height;

	if(iconbmfile != NULL){
		XReadBitmapFile(disp, win, iconbmfile, &width, &height, &bmap,
			&xh, &yh);
	}
	wmh.flags = IconPixmapHint | StateHint;
	wmh.icon_pixmap = bmap;
	if(iconbmmaskfile != NULL){
		XReadBitmapFile(disp, win, iconbmmaskfile, &width, &height,
			&bmapmask, &xh, &yh);
		wmh.icon_mask = bmapmask;
    }
    if(True == iconify){
        wmh.initial_state = IconicState;
    }else{
        wmh.initial_state = NormalState;
    }
    XSetWMHints(disp, win, &wmh);
}
