/*
 * usleep() : for HP-UX
 *
 * This usleep() is written with select(), however select()
 * spend amout of time, something around 20msec at least,
 * I recommend to do busy wait, if the time to sleep isn't
 * so long.
 *
 *			by taki@softlab.is.tsukuba.ac.jp
 *
 * N.B. This routine is modified to allow to receive signals
 *	while sleeping.
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/types.h>
#include <signal.h>

int usleep(microSeconds)
     unsigned long microSeconds;
{
  struct  timeval Timer;
  int omask;

  Timer.tv_sec  = microSeconds / (unsigned long) 1000000;
  Timer.tv_usec = microSeconds % (unsigned long) 1000000;

  omask = sigblock(sigmask(SIGIO));
  if( select( 0, NULL, NULL, NULL, &Timer ) < 0 ) {
    if (errno == EINTR)
      return(0);
    perror( "usleep (select) failed" );
    return(-1);
  }
  sigsetmask(omask);

  return(0);
}
